/**
 * MessageStrip designs.
 *
 * @readonly
 * @enum {string}
 * @public
 * @author SAP SE
 * @alias sap.ui.webc.main.types.MessageStripDesign
 */
var MessageStripDesign;
(function (MessageStripDesign) {
    /**
     * Message should be just an information
     * @public
     * @type {Information}
     */
    MessageStripDesign["Information"] = "Information";
    /**
     * Message is a success message
     * @public
     * @type {Positive}
     */
    MessageStripDesign["Positive"] = "Positive";
    /**
     * Message is an error
     * @public
     * @type {Negative}
     */
    MessageStripDesign["Negative"] = "Negative";
    /**
     * Message is a warning
     * @public
     * @type {Warning}
     */
    MessageStripDesign["Warning"] = "Warning";
})(MessageStripDesign || (MessageStripDesign = {}));
export default MessageStripDesign;
//# sourceMappingURL=MessageStripDesign.js.map