/**
 * Types of icon sizes used in the RatingIndicator.
 * Provides predefined size categories to ensure consistent scaling and spacing of icons.
 * @public
 * @since 2.6.0
 */
declare enum RatingIndicatorSize {
    /**
     * Small size for compact layouts.
     * @public
     */
    S = "S",
    /**
     * Medium size, used as the default option.
     * Offers a balanced appearance for most scenarios.
     * @public
     */
    M = "M",
    /**
     * Large size for prominent or spacious layouts.
     * @public
     */
    L = "L"
}
export default RatingIndicatorSize;
