# ![UI5 icon](https://raw.githubusercontent.com/UI5/webcomponents/main/docs/images/UI5_logo_water.png)UI5 Web Components - Main

[![npm Package Version](https://badge.fury.io/js/%40ui5%2Fwebcomponents.svg)](https://www.npmjs.com/package/@ui5/webcomponents)

Provides general purpose UI building blocks such as buttons, labels, inputs and popups.

## Provided components

| Web Component            | Tag name                    | Module import                                              |
|--------------------------|-----------------------------|------------------------------------------------------------|
| Avatar                   | `ui5-avatar`                | `import "@ui5/webcomponents/dist/Avatar.js";`              |
| Avatar Group             | `ui5-avatar-group`          | `import "@ui5/webcomponents/dist/AvatarGroup.js";`         |
| Bar                      | `ui5-bar`                   | `import "@ui5/webcomponents/dist/Bar.js";`                 |
| Breadcrumbs              | `ui5-breadcrumbs`           | `import "@ui5/webcomponents/dist/Breadcrumbs.js";`         |
| Breadcrumbs Item         | `ui5-breadcrumbs-item`      | comes with `ui5-breadcrumbs`                               |
| Tag                      | `ui5-tag`                   | `import "@ui5/webcomponents/dist/Tag.js";`                 |
| Busy Indicator           | `ui5-busy-indicator`        | `import "@ui5/webcomponents/dist/BusyIndicator.js";`       |
| Button                   | `ui5-button`                | `import "@ui5/webcomponents/dist/Button.js";`              |
| ButtonBadge              | `ui5-button-badge`          | `import "@ui5/webcomponents/dist/ButtonBadge.js";`         |
| Calendar                 | `ui5-calendar`              | `import "@ui5/webcomponents/dist/Calendar.js";`            |
| Calendar Date            | `ui5-date`                  | comes with `ui5-calendar`                                  |
| Calendar Date Range      | `ui5-date-range`            | comes with `ui5-calendar`                                  |
| Calendar Special Date    | `ui5-date-special`          | comes with `ui5-calendar`                                  |
| Calendar Legend          | `ui5-calendar-legend`       | `import "@ui5/webcomponents/dist/CalendarLegend.js";`      |
| Calendar Legend Item     | `ui5-calendar-legend-item`  | comes with `ui5-calendar-legend`                           |
| Card                     | `ui5-card`                  | `import "@ui5/webcomponents/dist/Card.js";`                |
| CardHeader               | `ui5-card-header`           | `import "@ui5/webcomponents/dist/CardHeader.js";`          |
| Carousel                 | `ui5-carousel`              | `import "@ui5/webcomponents/dist/Carousel.js";`            |
| Checkbox                 | `ui5-checkbox`              | `import "@ui5/webcomponents/dist/CheckBox.js";`            |
| Color Palette            | `ui5-color-palette`         | `import "@ui5/webcomponents/dist/ColorPalette.js";`        |
| Color Palette Item       | `ui5-color-palette-item`    | comes with `ui5-color-palette`                             |
| Color Palette Popover    | `ui5-color-palette-popover` | `import "@ui5/webcomponents/dist/ColorPalettePopover.js";` |
| Color Picker             | `ui5-color-picker`          | `import "@ui5/webcomponents/dist/ComboPicker.js";`         |
| ComboBox                 | `ui5-combobox`              | `import "@ui5/webcomponents/dist/ComboBox.js";`            |
| ComboBox Item            | `ui5-cb-item`               | comes with `ui5-combobox`                                  |
| ComboBox Group Item      | `ui5-cb-group-item`         | comes with `ui5-combobox`                                  |
| Date Picker              | `ui5-date-picker`           | `import "@ui5/webcomponents/dist/DatePicker.js";`          |
| Date Range Picker        | `ui5-daterange-picker`      | `import "@ui5/webcomponents/dist/DateRangePicker.js";`     |
| Date Time Picker         | `ui5-datetime-picker`       | `import "@ui5/webcomponents/dist/DateTimePicker.js";`      |
| Dialog                   | `ui5-dialog`                | `import "@ui5/webcomponents/dist/Dialog.js";`              |
| File Uploader            | `ui5-file-uploader`         | `import "@ui5/webcomponents/dist/FileUploader.js";`        |
| Icon                     | `ui5-icon`                  | `import "@ui5/webcomponents/dist/Icon.js";`                |
| Input                    | `ui5-input`                 | `import "@ui5/webcomponents/dist/Input.js";`               |
| Label                    | `ui5-label`                 | `import "@ui5/webcomponents/dist/Label.js";`               |
| Link                     | `ui5-link`                  | `import "@ui5/webcomponents/dist/Link.js";`                |
| List                     | `ui5-list`                  | `import "@ui5/webcomponents/dist/List.js";`                |
| List - Standard Item     | `ui5-li`                    | `import "@ui5/webcomponents/dist/ListItemStandard.js";`    |
| List - Custom Item       | `ui5-li-custom`             | `import "@ui5/webcomponents/dist/ListItemCustom.js";`      |
| List - Group Item        | `ui5-li-group`              | `import "@ui5/webcomponents/dist/ListItemGroup.js";`       |
| Menu                     | `ui5-menu`                  | `import "@ui5/webcomponents/dist/Menu.js";`                |
| Menu Item                | `ui5-menu-item`             | comes with `ui5-menu`                                      |
| Menu Separator           | `ui5-menu-separator`        | comes with `ui5-menu`                                      |
| Message Strip            | `ui5-message-strip`         | `import "@ui5/webcomponents/dist/MessageStrip.js";`        |
| Multi ComboBox           | `ui5-multi-combobox`        | `import "@ui5/webcomponents/dist/MultiComboBox.js";`       |
| Multi ComboBox Item      | `ui5-mcb-item`              | comes with `ui5-multi-combobox`                            |
| Multi ComboBox Item Group| `ui5-mcb-item-group`        | comes with `ui5-multi-combobox`                            |
| Multi Input              | `ui5-multi-input`           | `import "@ui5/webcomponents/dist/MultiInput.js";`          |
| Panel                    | `ui5-panel`                 | `import "@ui5/webcomponents/dist/Panel.js";`               |
| Popover                  | `ui5-popover`               | `import "@ui5/webcomponents/dist/Popover.js";`             |
| ProgressIndicator        | `ui5-progress-indicator`    | `import "@ui5/webcomponents/dist/ProgressIndicator.js";`   |
| Radio Button             | `ui5-radio-button`          | `import "@ui5/webcomponents/dist/RadioButton.js";`         |
| Range Slider             | `ui5-range-slider`          | `import "@ui5/webcomponents/dist/RangeSlider.js";`         |
| Rating Indicator         | `ui5-rating-indicator`      | `import "@ui5/webcomponents/dist/RatingIndicator.js";`     |
| Responsive Popover       | `ui5-responsive-popover`    | `import "@ui5/webcomponents/dist/ResponsivePopover.js";`   |
| Segmented Button         | `ui5-segmented-button`      | `import "@ui5/webcomponents/dist/SegmentedButton.js";`     |
| Segmented Button Item    | `ui5-segmented-button-item` | comes with `ui5-segmented-button `                         |
| Select                   | `ui5-select`                | `import "@ui5/webcomponents/dist/Select.js";`              |
| Select Option            | `ui5-option`                | comes with `ui5-select `                                   |
| Slider                   | `ui5-slider`                | `import "@ui5/webcomponents/dist/Slider.js";`              |
| Split Button             | `ui5-split-button`          | `import "@ui5/webcomponents/dist/SplitButton.js";`         |
| Step Input               | `ui5-step-input`            | `import "@ui5/webcomponents/dist/StepInput.js";`           |
| Suggestion Item          | `ui5-suggestion-item`       | comes with `InputSuggestions.js` feature - see below       |
| Switch                   | `ui5-switch`                | `import "@ui5/webcomponents/dist/Switch.js";`              |
| Tab Container            | `ui5-tabcontainer`          | `import "@ui5/webcomponents/dist/TabContainer.js";`        |
| Tab                      | `ui5-tab`                   | `import "@ui5/webcomponents/dist/Tab.js";`                 |
| Tab Separator            | `ui5-tab-separator`         | `import "@ui5/webcomponents/dist/TabSeparator.js";`        |
| Textarea                 | `ui5-textarea`              | `import "@ui5/webcomponents/dist/TextArea.js";`            |
| TimePicker               | `ui5-time-picker`           | `import "@ui5/webcomponents/dist/TimePicker.js";`          |
| Title                    | `ui5-title`                 | `import "@ui5/webcomponents/dist/Title.js";`               |
| Toast                    | `ui5-toast`                 | `import "@ui5/webcomponents/dist/Toast.js";`               |
| Toggle Button            | `ui5-toggle-button`         | `import "@ui5/webcomponents/dist/ToggleButton.js";`        |
| Token                    | `ui5-token`                 | comes with `ui5-multi-input`                               |
| Tree                     | `ui5-tree`                  | `import "@ui5/webcomponents/dist/Tree.js";`                |
| Tree Item                | `ui5-tree-item`             | comes with `ui5-tree`                                      |
| Tree Item Custom         | `ui5-tree-item-custom`      | comes with `ui5-tree`                                      |

## Provided assets

`import "@ui5/webcomponents/dist/Assets.js";`

| Assets | Module | Notes
|------------|-----------|-----------
| `i18n`, `themes` | `@ui5/webcomponents/dist/Assets.js` | Theming parameters and translations for the components  <br/><br/> *Automatically imports also:<br/> `@ui5/webcomponents-localization/dist/Assets.js` <br/> and <br/> `@ui5/webcomponents-theming/dist/Assets.js`*

## Provided features

| Feature name             | Affects                                               | Triggered by                            | Description                                                                                             |
|--------------------------|-------------------------------------------------------|-----------------------------------------|---------------------------------------------------------------------------------------------------------|
| More Colors Dialog       | `ui5-color-palette`, `ui5-color-palette-popover`      | Setting `showMoreColors` to `true`      | Support for "more colors dialog" for the color palette component                                        |
| Input Suggestions        | `ui5-input`, `ui5-multi-input`                        | Setting `showSuggestions` to `true`     | Support for input suggestions while typing                                                              |

### Color Palette "More Colors" Feature

The `ui5-color-palette` component has a `showMoreColors` property, that, when set to `true`, enables a "More colors" dialog.
Since this functionality is not always needed, the "More colors" dialog and its children are not direct dependencies of the component by default,
and are only loaded dynamically when `showMoreColors` is set to `true`.

Feature import (optional as of `2.7.0`): 

```js
import "@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js";
```

You can optionally pre-load the feature (thus avoiding the dynamic import), if you prefer so. 

### Input Suggestions Feature

The `<ui5-input>` element acts as an `<input>` with the Fiori design and added functionality, such as value state.

The so-called "input suggestions" is an advanced feature that allows the user to choose from a list of predefined options while typing.
Since input suggestions may not always be needed, they do not come as part of the `<ui5-input>` itself.

Setting the `showSuggestions` property to `true` loads the suggestions feature dynamically (as well as the `ui5-suggestion-item` component) for your convenience.

Feature import (optional as of `2.7.0`):  

```js
import "@ui5/webcomponents/dist/features/InputSuggestions.js";
```

You can optionally pre-load the feature (thus avoiding the dynamic import), if you prefer so.

## Resources
- [UI5 Web Components - README.md](https://github.com/UI5/webcomponents/blob/main/README.md)
- [UI5 Web Components - Home Page](https://ui5.github.io/webcomponents)
- [UI5 Web Components - Playground and API Reference](https://ui5.github.io/webcomponents/play/)

## Support
We welcome all comments, suggestions, questions, and bug reports. Please follow our [Support Guidelines](https://github.com/UI5/webcomponents/blob/main/SUPPORT.md#-content) on how to report an issue, or chat with us in the `#webcomponents` channel of the [OpenUI5 Community Slack](https://ui5-slack-invite.cfapps.eu10.hana.ondemand.com/).

## Contribute
Please check our [Contribution Guidelines](https://github.com/UI5/webcomponents/blob/main/docs/6-contributing/02-conventions-and-guidelines.md).

## License
Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
This file is licensed under the Apache Software License, Version 2.0 except as noted otherwise in the [LICENSE](https://github.com/UI5/webcomponents/blob/main/LICENSE.txt) file.
