import UI5Date from "@ui5/webcomponents-localization/dist/dates/UI5Date.js";
const dateOptionToDates = (value) => {
    const startDate = value.values ? value.values[0] : UI5Date.getInstance();
    const endDate = UI5Date.getInstance(startDate.getTime());
    startDate?.setHours(0, 0, 0, 0);
    endDate?.setHours(23, 59, 59, 999);
    return [startDate, endDate];
};
const dateRangeOptionToDates = (value) => {
    const startDate = value.values ? value.values[0] : UI5Date.getInstance();
    const endDate = value.values ? value.values[1] : UI5Date.getInstance();
    startDate?.setHours(0, 0, 0, 0);
    endDate?.setHours(23, 59, 59, 999);
    return [startDate, endDate];
};
const todayToDates = () => {
    const startDate = UI5Date.getInstance();
    const endDate = UI5Date.getInstance();
    startDate.setHours(0, 0, 0, 0);
    endDate.setHours(23, 59, 59, 999);
    return [startDate, endDate];
};
const yesterdayToDates = () => {
    const startDate = UI5Date.getInstance();
    const endDate = UI5Date.getInstance();
    startDate.setHours(0, 0, 0, 0);
    startDate.setDate(startDate.getDate() - 1);
    endDate.setHours(23, 59, 59, 999);
    endDate.setDate(endDate.getDate() - 1);
    return [startDate, endDate];
};
const tomorrowToDates = () => {
    const startDate = UI5Date.getInstance();
    const endDate = UI5Date.getInstance();
    startDate.setHours(0, 0, 0, 0);
    startDate.setDate(startDate.getDate() + 1);
    endDate.setHours(23, 59, 59, 999);
    endDate.setDate(endDate.getDate() + 1);
    return [startDate, endDate];
};
const lastToDates = (value, unit) => {
    const today = UI5Date.getInstance();
    const startDate = UI5Date.getInstance(today.getTime());
    const endDate = UI5Date.getInstance(today.getTime());
    const amount = value.values?.[0] || 1;
    switch (unit) {
        case "days":
            // For "Last X Days": start X days before today (inclusive), end today
            // "Last 1 Day" = today only, "Last 2 Days" = yesterday + today, etc.
            startDate.setDate(today.getDate() - (amount - 1));
            break;
        case "weeks": {
            const currentDayOfWeek = today.getDay();
            const daysToStartOfWeek = currentDayOfWeek === 0 ? 6 : currentDayOfWeek - 1;
            startDate.setDate(today.getDate() - daysToStartOfWeek - ((amount - 1) * 7));
            break;
        }
        case "months":
            startDate.setMonth(today.getMonth() - (amount - 1));
            startDate.setDate(1); // Start of the month
            break;
        case "quarters": {
            const currentQuarter = Math.floor(today.getMonth() / 3);
            const quarterStartMonth = currentQuarter * 3 - ((amount - 1) * 3);
            startDate.setMonth(quarterStartMonth);
            startDate.setDate(1); // Start of the quarter
            break;
        }
        case "years":
            startDate.setFullYear(today.getFullYear() - (amount - 1));
            startDate.setMonth(0); // January
            startDate.setDate(1); // Start of the year
            break;
    }
    return [startDate, endDate];
};
const nextToDates = (value, unit) => {
    const today = UI5Date.getInstance();
    const startDate = UI5Date.getInstance(today.getTime());
    const endDate = UI5Date.getInstance(today.getTime());
    const amount = value.values?.[0] || 1;
    switch (unit) {
        case "days":
            // For "Next X Days": start today, end X days from today (inclusive)
            // "Next 1 Day" = today only, "Next 2 Days" = today + tomorrow, etc.
            endDate.setDate(today.getDate() + (amount - 1));
            break;
        case "weeks": {
            const currentDayOfWeek = today.getDay();
            const daysToEndOfWeek = currentDayOfWeek === 0 ? 0 : 7 - currentDayOfWeek;
            endDate.setDate(today.getDate() + daysToEndOfWeek + ((amount - 1) * 7));
            break;
        }
        case "months":
            endDate.setMonth(today.getMonth() + amount);
            endDate.setDate(0); // Last day of the previous month (the target month)
            break;
        case "quarters": {
            const currentQuarter = Math.floor(today.getMonth() / 3);
            const quarterEndMonth = (currentQuarter + 1) * 3 - 1 + ((amount - 1) * 3);
            endDate.setMonth(quarterEndMonth + 1);
            endDate.setDate(0); // Last day of the quarter
            break;
        }
        case "years":
            endDate.setFullYear(today.getFullYear() + amount);
            endDate.setMonth(0); // January of the next year
            endDate.setDate(0); // Last day of December of the target year
            break;
    }
    return [startDate, endDate];
};
const lastNextToDates = (value, unit, direction) => {
    return direction === "last" ? lastToDates(value, unit) : nextToDates(value, unit);
};
/**
 * Converts DynamicDateRangeValue to dates for Last/Next options.
 * Uses operator name to determine time unit and direction.
 */
const toDatesLastNext = (value, option) => {
    const operator = option.operator;
    // Extract direction from operator name
    let direction;
    if (operator.startsWith("LAST")) {
        direction = "last";
    }
    else if (operator.startsWith("NEXT")) {
        direction = "next";
    }
    else {
        // Not a LastNext option, return today's date range
        return todayToDates();
    }
    // Extract time unit from operator name
    let unit;
    if (operator.includes("DAYS")) {
        unit = "days";
    }
    else if (operator.includes("WEEKS")) {
        unit = "weeks";
    }
    else if (operator.includes("MONTHS")) {
        unit = "months";
    }
    else if (operator.includes("QUARTERS")) {
        unit = "quarters";
    }
    else if (operator.includes("YEARS")) {
        unit = "years";
    }
    else {
        // Unknown time unit, return today's date range as fallback
        return todayToDates();
    }
    return lastNextToDates(value, unit, direction);
};
export { dateOptionToDates, dateRangeOptionToDates, todayToDates, tomorrowToDates, yesterdayToDates, lastNextToDates, toDatesLastNext, };
//# sourceMappingURL=toDates.js.map