import ListItemStandard from "./ListItemStandard.js";
/**
 * @class
 * The `ui5-li-suggestion-item` represents the suggestion item in the `ui5-input`
 * suggestion popover.
 * @constructor
 * @extends ListItemStandard
 * @csspart title - Used to style the title of the suggestion list item
 * @csspart description - Used to style the description of the suggestion list item
 * @csspart info - Used to style the info of the suggestion list item
 */
declare class SuggestionListItem extends ListItemStandard {
    /**
     * Defines a description that can contain HTML.
     * **Note:** If not specified, the `description` property will be used.
     * @since 1.0.0-rc.8
     * @public
     */
    richDescription: Array<HTMLElement>;
    /**
     * Defines the title text of the suggestion item.
     * @public
     */
    titleText: Array<Node>;
    onBeforeRendering(): void;
    get effectiveTitle(): string;
    get hasDescription(): string | number | undefined;
    get groupItem(): boolean;
}
export default SuggestionListItem;
