import { jsx as _jsx, jsxs as _jsxs } from "@ui5/webcomponents-base/jsx-runtime";
import Label from "./Label.js";
import Slider from "./Slider.js";
import Input from "./Input.js";
export default function ColorPickerTemplate() {
    return (_jsxs("section", { class: "ui5-color-picker-root", children: [_jsx("div", { class: "ui5-color-picker-main-color", style: { "background-color": `rgb(${this._mainValue.r}, ${this._mainValue.g}, ${this._mainValue.b})` }, onMouseDown: this._handleMouseDown, onMouseUp: this._handleMouseUp, onMouseMove: this._handleMouseMove, onMouseOut: this._handleMouseOut, children: _jsx("div", { class: "ui5-color-picker-circle", style: {
                        left: `${this._selectedCoordinates.x}px`,
                        top: `${this._selectedCoordinates.y}px`,
                    } }) }), _jsxs("div", { class: "ui5-color-picker-sliders-wrapper", children: [_jsx(Slider, { disabled: this.inputsDisabled, class: "ui5-color-picker-hue-slider", min: 0, max: 360, step: 1, value: this._hue, accessibleName: this.hueSliderLabel, showTooltip: true, onInput: this._handleHueInput }), this._isDefaultPickerMode &&
                        _jsx(Slider, { disabled: this.inputsDisabled, class: "ui5-color-picker-alpha-slider", min: 0, max: 1, step: 0.01, value: this._alpha, accessibleName: this.alphaSliderLabel, showTooltip: true, onInput: this._handleAlphaInputFromSlider })] }), _jsxs("div", { class: "ui5-color-picker-current-color", children: [_jsxs("div", { class: "ui5-color-picker-colors-wrapper", children: [_jsx("span", { class: "ui5-color-picker-white" }), _jsx("span", { class: "ui5-color-picker-color", children: _jsx("div", { class: "ui5-color-picker-color-inner", style: { "background-color": `rgba(${this._value.r}, ${this._value.g}, ${this._value.b}, ${this._alpha})` } }) })] }), _jsxs("div", { class: "ui5-color-picker-hex-input-wrapper", children: [_jsx(Label, { children: "Hex" }), _jsx(Input, { class: "ui5-color-picker-hex-input", value: this.hex, onKeyDown: this._onkeydown, accessibleName: this.hexInputLabel, onChange: this._handleHEXChange, valueState: this.hexInputErrorState })] })] }), this._isDefaultPickerMode &&
                _jsxs("div", { class: "ui5-color-picker-rgb-wrapper", "onui5-change": this._handleRGBInputsChange, children: [_jsxs("div", { class: "ui5-color-picker-rgb", children: [_jsx(Input, { id: "red", class: "ui5-color-picker-rgb-input", disabled: this.inputsDisabled, accessibleName: this.redInputLabel, value: String(this._value.r) }), _jsx(Label, { children: "R" })] }), _jsxs("div", { class: "ui5-color-picker-rgb", children: [_jsx(Input, { id: "green", class: "ui5-color-picker-rgb-input", disabled: this.inputsDisabled, accessibleName: this.greenInputLabel, value: String(this._value.g) }), _jsx(Label, { children: "G" })] }), _jsxs("div", { class: "ui5-color-picker-rgb", children: [_jsx(Input, { id: "blue", class: "ui5-color-picker-rgb-input", disabled: this.inputsDisabled, accessibleName: this.blueInputLabel, value: String(this._value.b) }), _jsx(Label, { children: "B" })] }), _jsxs("div", { class: "ui5-color-picker-rgb", children: [_jsx(Input, { id: "alpha", disabled: this.inputsDisabled, class: "ui5-color-picker-rgb-input", value: String(this._alpha), accessibleName: this.alphaInputLabel, onChange: this._handleAlphaChange }), _jsx(Label, { children: "A" })] })] })] }));
}
//# sourceMappingURL=ColorPickerTemplate.js.map