/**
 * ListItem accessible roles.
 * @public
 * @since 2.0.0
 */
declare enum ListItemAccessibleRole {
    /**
     * Represents the ARIA role "listitem". (by default)
     * @public
     */
    ListItem = "ListItem",
    /**
     * Represents the ARIA role "menuitem".
     * @public
     */
    MenuItem = "MenuItem",
    /**
     * Represents the ARIA role "treeitem".
     * @public
     */
    TreeItem = "TreeItem",
    /**
     * Represents the ARIA role "option".
     * @public
     */
    Option = "Option",
    /**
     * Represents the ARIA role "none".
     * @public
     */
    None = "None"
}
export default ListItemAccessibleRole;
