/**
 * Types of icon sizes used in the RatingIndicator.
 * Provides predefined size categories to ensure consistent scaling and spacing of icons.
 * @public
 * @since 2.6.0
 */
var RatingIndicatorSize;
(function (RatingIndicatorSize) {
    /**
     * Small size for compact layouts.
     * @public
     */
    RatingIndicatorSize["S"] = "S";
    /**
     * Medium size, used as the default option.
     * Offers a balanced appearance for most scenarios.
     * @public
     */
    RatingIndicatorSize["M"] = "M";
    /**
     * Large size for prominent or spacious layouts.
     * @public
     */
    RatingIndicatorSize["L"] = "L";
})(RatingIndicatorSize || (RatingIndicatorSize = {}));
export default RatingIndicatorSize;
//# sourceMappingURL=RatingIndicatorSize.js.map