import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "@ui5/webcomponents-base/jsx-runtime";
import Label from "./Label.js";
import Slider from "./Slider.js";
import Input from "./Input.js";
import Button from "./Button.js";
export default function ColorPickerTemplate() {
    return (_jsxs("section", { class: "ui5-color-picker-root", children: [_jsx("div", { class: "ui5-color-picker-main-color", style: { "background-color": `rgb(${this._mainValue.r}, ${this._mainValue.g}, ${this._mainValue.b})` }, onMouseDown: this._handleMouseDown, onMouseUp: this._handleMouseUp, onMouseMove: this._handleMouseMove, onMouseOut: this._handleMouseOut, children: _jsx("div", { class: "ui5-color-picker-circle", style: {
                        left: `${this._selectedCoordinates.x}px`,
                        top: `${this._selectedCoordinates.y}px`,
                    } }) }), _jsxs("div", { class: "ui5-color-picker-sliders-wrapper", children: [_jsx(Slider, { disabled: this.inputsDisabled, class: "ui5-color-picker-hue-slider", min: 0, max: 360, step: 1, value: this._hue, accessibleName: this.hueSliderLabel, showTooltip: true, onInput: this._handleHueInput }), this._isDefaultPickerMode &&
                        _jsx(Slider, { disabled: this.inputsDisabled, class: "ui5-color-picker-alpha-slider", min: 0, max: 1, step: 0.01, value: this._alpha, accessibleName: this.alphaSliderLabel, showTooltip: true, onInput: this._handleAlphaInput })] }), _jsxs("div", { class: "ui5-color-picker-current-color", children: [_jsxs("div", { class: "ui5-color-picker-colors-wrapper", children: [_jsx("span", { class: "ui5-color-picker-white" }), _jsx("span", { class: "ui5-color-picker-color", children: _jsx("div", { class: "ui5-color-picker-color-inner", style: { "background-color": this._colorValue.toRGBString() } }) })] }), _jsxs("div", { class: "ui5-color-picker-hex-input-wrapper", children: [_jsx(Label, { children: "Hex" }), _jsx(Input, { class: "ui5-color-picker-hex-input", value: this.HEX, onKeyDown: this._onkeydown, accessibleName: this.hexInputLabel, onChange: this._handleHEXChange, valueState: this.hexInputErrorState })] })] }), this._isDefaultPickerMode &&
                _jsxs("div", { class: "ui5-color-channel-inputs-wrapper", "onui5-change": this._handleColorInputChange, children: [this.colorChannelInputs.map(input => _jsxs(_Fragment, { children: [_jsxs("div", { class: "ui5-color-channel", children: [_jsx(Input, { id: input.id, class: "ui5-color-channel-input", disabled: this.inputsDisabled, accessibleName: input.accessibleName, value: String(input.value) }), _jsx(Label, { children: input.label })] }), _jsx("div", { class: "ui5-color-channel-percentage-label", children: input.showPercentSymbol &&
                                        _jsx(Label, { children: "%" }) })] })), _jsxs("div", { class: "ui5-color-channel", children: [_jsx(Input, { id: "alpha", disabled: this.inputsDisabled, class: "ui5-color-channel-input", value: String(this._alpha), accessibleName: this.alphaInputLabel, onChange: this._handleAlphaChange, onInput: this._handleAlphaInput }), _jsx(Label, { children: "A" })] }), _jsx("div", { children: _jsx(Button, { class: "ui5-color-channel-toggle", id: "toggle-picker-mode", icon: "expand", design: "Transparent", tooltip: this.toggleModeTooltip, onClick: this._togglePickerMode }) })] })] }));
}
//# sourceMappingURL=ColorPickerTemplate.js.map