import TableCellBase from "./TableCellBase.js";
/**
 * @class
 *
 * ### Overview
 *
 * The `ui5-table-cell` represents a cell inside of a `ui5-table`.
 * It is tightly coupled to the `ui5-table` and thus should only be used in the table component.
 *
 * ### ES6 Module Import
 *
 * `import @ui5/webcomponents/dist/TableCell.js;`
 *
 * @constructor
 * @extends TableCellBase
 * @since 2.0.0
 * @public
 * @experimental This web component is available since 2.0 with an experimental flag and its API and behavior are subject to change.
 */
declare class TableCell extends TableCellBase {
    onBeforeRendering(): void;
    get _headerCell(): import("./TableHeaderCell.js").default;
    get _popinText(): string | undefined;
    get _popinHeader(): Node;
    get _i18nPopinColon(): string;
}
export default TableCell;
