/**
 * Different Icon semantic designs.
 * @public
 */
declare enum IconDesign {
    /**
     * Contrast design
     * @public
     */
    Contrast = "Contrast",
    /**
     * Critical design
     * @public
     */
    Critical = "Critical",
    /**
     * Default design (brand design)
     * @public
    */
    Default = "Default",
    /**
     * info type
     * @public
     */
    Information = "Information",
    /**
     * Negative design
     * @public
     */
    Negative = "Negative",
    /**
     * Neutral design
     * @public
     */
    Neutral = "Neutral",
    /**
     * Design that indicates an icon which isn't interactive
     * @public
     */
    NonInteractive = "NonInteractive",
    /**
     * Positive design
     * @public
     */
    Positive = "Positive"
}
export default IconDesign;
