/**
 * Toast placement.
 * @public
 */
declare enum ToastPlacement {
    /**
     * Toast is placed at the `TopStart` position of its container.
     * @public
     */
    TopStart = "TopStart",
    /**
     * Toast is placed at the `TopCenter` position of its container.
     * @public
     */
    TopCenter = "TopCenter",
    /**
     * Toast is placed at the `TopEnd` position of its container.
     * @public
     */
    TopEnd = "TopEnd",
    /**
     * Toast is placed at the `MiddleStart` position of its container.
     * @public
     */
    MiddleStart = "MiddleStart",
    /**
     * Toast is placed at the `MiddleCenter` position of its container.
     * @public
     */
    MiddleCenter = "MiddleCenter",
    /**
     * Toast is placed at the `MiddleEnd` position of its container.
     * @public
     */
    MiddleEnd = "MiddleEnd",
    /**
     * Toast is placed at the `BottomStart` position of its container.
     * @public
     */
    BottomStart = "BottomStart",
    /**
     * Toast is placed at the `BottomCenter` position of its container.
     * Default placement (no selection)
     * @public
     */
    BottomCenter = "BottomCenter",
    /**
     * Toast is placed at the `BottomEnd` position of its container.
     * @public
     */
    BottomEnd = "BottomEnd"
}
export default ToastPlacement;
