/**
 * # Legacy state events
 *
 * Polyfill implementation of the UI-Router 0.2.x state events.
 *
 * The 0.2.x state events are deprecated.  We recommend moving to Transition Hooks instead, as they
 * provide much more flexibility, support async, and provide the context (the Transition, etc) necessary
 * to implement meaningful application behaviors.
 *
 * To enable these state events, include the `stateEvents.js` file in your project, e.g.,
 * ```
 * <script src="stateEvents.js"></script>
 * ```
 * and also make sure you depend on the `ui.router.state.events` angular module, e.g.,
 * ```
 * angular.module("myApplication", ['ui.router', 'ui.router.state.events']
 * ```
 *
 * @module ng1_state_events
 */ /** */
import { ng as angular } from "../angular";
/**
 * An event broadcast on `$rootScope` when the state transition **begins**.
 *
 * ### Deprecation warning: use [[TransitionService.onStart]] instead
 *
 * You can use `event.preventDefault()`
 * to prevent the transition from happening and then the transition promise will be
 * rejected with a `'transition prevented'` value.
 *
 * Additional arguments to the event handler are provided:
 * - `toState`: the Transition Target state
 * - `toParams`: the Transition Target Params
 * - `fromState`: the state the transition is coming from
 * - `fromParams`: the parameters from the state the transition is coming from
 * - `options`: any Transition Options
 * - `$transition$`: the [[Transition]]
 *
 * #### Example:
 * ```js
 * $rootScope.$on('$stateChangeStart', function(event, transition) {
 *   event.preventDefault();
 *   // transitionTo() promise will be rejected with
 *   // a 'transition prevented' error
 * })
 * ```
 *
 * @event $stateChangeStart
 * @deprecated
 */
export var $stateChangeStart;
/**
 * An event broadcast on `$rootScope` if a transition is **cancelled**.
 *
 * ### Deprecation warning: use [[TransitionService.onStart]] instead
 *
 * Additional arguments to the event handler are provided:
 * - `toState`: the Transition Target state
 * - `toParams`: the Transition Target Params
 * - `fromState`: the state the transition is coming from
 * - `fromParams`: the parameters from the state the transition is coming from
 * - `options`: any Transition Options
 * - `$transition$`: the [[Transition]] that was cancelled
 *
 * @event $stateChangeCancel
 * @deprecated
 */
export var $stateChangeCancel;
/**
 * An event broadcast on `$rootScope` once the state transition is **complete**.
 *
 * ### Deprecation warning: use [[TransitionService.onStart]] and [[Transition.promise]], or [[Transition.onSuccess]]
 *
 * Additional arguments to the event handler are provided:
 * - `toState`: the Transition Target state
 * - `toParams`: the Transition Target Params
 * - `fromState`: the state the transition is coming from
 * - `fromParams`: the parameters from the state the transition is coming from
 * - `options`: any Transition Options
 * - `$transition$`: the [[Transition]] that just succeeded
 *
 * @event $stateChangeSuccess
 * @deprecated
 */
export var $stateChangeSuccess;
/**
 * An event broadcast on `$rootScope` when an **error occurs** during transition.
 *
 * ### Deprecation warning: use [[TransitionService.onStart]] and [[Transition.promise]], or [[Transition.onError]]
 *
 * It's important to note that if you
 * have any errors in your resolve functions (javascript errors, non-existent services, etc)
 * they will not throw traditionally. You must listen for this $stateChangeError event to
 * catch **ALL** errors.
 *
 * Additional arguments to the event handler are provided:
 * - `toState`: the Transition Target state
 * - `toParams`: the Transition Target Params
 * - `fromState`: the state the transition is coming from
 * - `fromParams`: the parameters from the state the transition is coming from
 * - `error`: The reason the transition errored.
 * - `options`: any Transition Options
 * - `$transition$`: the [[Transition]] that errored
 *
 * @event $stateChangeError
 * @deprecated
 */
export var $stateChangeError;
/**
 * An event broadcast on `$rootScope` when a requested state **cannot be found** using the provided state name.
 *
 * ### Deprecation warning: use [[StateService.onInvalid]] instead
 *
 * The event is broadcast allowing any handlers a single chance to deal with the error (usually by
 * lazy-loading the unfound state). A `TargetState` object is passed to the listener handler,
 * you can see its properties in the example. You can use `event.preventDefault()` to abort the
 * transition and the promise returned from `transitionTo()` will be rejected with a
 * `'transition aborted'` error.
 *
 * Additional arguments to the event handler are provided:
 * - `unfoundState` Unfound State information. Contains: `to, toParams, options` properties.
 * - `fromState`: the state the transition is coming from
 * - `fromParams`: the parameters from the state the transition is coming from
 * - `options`: any Transition Options
 *
 * #### Example:
 * ```js
 * // somewhere, assume lazy.state has not been defined
 * $state.go("lazy.state", { a: 1, b: 2 }, { inherit: false });
 *
 * // somewhere else
 * $scope.$on('$stateNotFound', function(event, transition) {
 * function(event, unfoundState, fromState, fromParams){
 *     console.log(unfoundState.to); // "lazy.state"
 *     console.log(unfoundState.toParams); // {a:1, b:2}
 *     console.log(unfoundState.options); // {inherit:false} + default options
 * });
 * ```
 *
 * @event $stateNotFound
 * @deprecated
 */
export var $stateNotFound;
(function () {
    var isFunction = angular.isFunction, isString = angular.isString;
    function applyPairs(memo, keyValTuple) {
        var key, value;
        if (Array.isArray(keyValTuple))
            key = keyValTuple[0], value = keyValTuple[1];
        if (!isString(key))
            throw new Error("invalid parameters to applyPairs");
        memo[key] = value;
        return memo;
    }
    function stateChangeStartHandler($transition$) {
        if (!$transition$.options().notify || !$transition$.valid() || $transition$.ignored())
            return;
        var $injector = $transition$.injector();
        var $stateEvents = $injector.get('$stateEvents');
        var $rootScope = $injector.get('$rootScope');
        var $state = $injector.get('$state');
        var $urlRouter = $injector.get('$urlRouter');
        var enabledEvents = $stateEvents.provider.enabled();
        var toParams = $transition$.params("to");
        var fromParams = $transition$.params("from");
        if (enabledEvents.$stateChangeSuccess) {
            var startEvent = $rootScope.$broadcast('$stateChangeStart', $transition$.to(), toParams, $transition$.from(), fromParams, $transition$.options(), $transition$);
            if (startEvent.defaultPrevented) {
                if (enabledEvents.$stateChangeCancel) {
                    $rootScope.$broadcast('$stateChangeCancel', $transition$.to(), toParams, $transition$.from(), fromParams, $transition$.options(), $transition$);
                }
                //Don't update and resync url if there's been a new transition started. see issue #2238, #600
                if ($state.transition == null)
                    $urlRouter.update();
                return false;
            }
            // right after global state is updated
            var successOpts = { priority: 9999 };
            $transition$.onSuccess({}, function () {
                $rootScope.$broadcast('$stateChangeSuccess', $transition$.to(), toParams, $transition$.from(), fromParams, $transition$.options(), $transition$);
            }, successOpts);
        }
        if (enabledEvents.$stateChangeError) {
            $transition$.promise["catch"](function (error) {
                if (error && (error.type === 2 /* RejectType.SUPERSEDED */ || error.type === 3 /* RejectType.ABORTED */))
                    return;
                var evt = $rootScope.$broadcast('$stateChangeError', $transition$.to(), toParams, $transition$.from(), fromParams, error, $transition$.options(), $transition$);
                if (!evt.defaultPrevented) {
                    $urlRouter.update();
                }
            });
        }
    }
    stateNotFoundHandler.$inject = ['$to$', '$from$', '$state', '$rootScope', '$urlRouter'];
    function stateNotFoundHandler($to$, $from$, injector) {
        var $state = injector.get('$state');
        var $rootScope = injector.get('$rootScope');
        var $urlRouter = injector.get('$urlRouter');
        var redirect = { to: $to$.identifier(), toParams: $to$.params(), options: $to$.options() };
        var e = $rootScope.$broadcast('$stateNotFound', redirect, $from$.state(), $from$.params());
        if (e.defaultPrevented || e.retry)
            $urlRouter.update();
        function redirectFn() {
            return $state.target(redirect.to, redirect.toParams, redirect.options);
        }
        if (e.defaultPrevented) {
            return false;
        }
        else if (e.retry || !!$state.get(redirect.to)) {
            return e.retry && isFunction(e.retry.then) ? e.retry.then(redirectFn) : redirectFn();
        }
    }
    $StateEventsProvider.$inject = ['$stateProvider'];
    function $StateEventsProvider($stateProvider) {
        $StateEventsProvider.prototype.instance = this;
        var runtime = false;
        var allEvents = ['$stateChangeStart', '$stateNotFound', '$stateChangeSuccess', '$stateChangeError'];
        var enabledStateEvents = allEvents.map(function (e) { return [e, true]; }).reduce(applyPairs, {});
        function assertNotRuntime() {
            if (runtime)
                throw new Error("Cannot enable events at runtime (use $stateEventsProvider");
        }
        /**
         * Enables the deprecated UI-Router 0.2.x State Events
         * [ '$stateChangeStart', '$stateNotFound', '$stateChangeSuccess', '$stateChangeError' ]
         */
        this.enable = function () {
            var events = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                events[_i] = arguments[_i];
            }
            assertNotRuntime();
            if (!events || !events.length)
                events = allEvents;
            events.forEach(function (event) { return enabledStateEvents[event] = true; });
        };
        /**
         * Disables the deprecated UI-Router 0.2.x State Events
         * [ '$stateChangeStart', '$stateNotFound', '$stateChangeSuccess', '$stateChangeError' ]
         */
        this.disable = function () {
            var events = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                events[_i] = arguments[_i];
            }
            assertNotRuntime();
            if (!events || !events.length)
                events = allEvents;
            events.forEach(function (event) { return delete enabledStateEvents[event]; });
        };
        this.enabled = function () { return enabledStateEvents; };
        this.$get = $get;
        $get.$inject = ['$transitions'];
        function $get($transitions) {
            runtime = true;
            if (enabledStateEvents["$stateNotFound"])
                $stateProvider.onInvalid(stateNotFoundHandler);
            if (enabledStateEvents.$stateChangeStart)
                $transitions.onBefore({}, stateChangeStartHandler, { priority: 1000 });
            return {
                provider: $StateEventsProvider.prototype.instance
            };
        }
    }
    angular.module('ui.router.state.events', ['ui.router.state'])
        .provider("$stateEvents", $StateEventsProvider)
        .run(['$stateEvents', function ($stateEvents) {
        }]);
})();
//# sourceMappingURL=data:application/json;base64,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