import { val, createProxyFunctions, removeFrom, isObject } from "@uirouter/core";
/**
 * Implements UI-Router LocationServices and LocationConfig using Angular 1's $location service
 */
var Ng1LocationServices = (function () {
    function Ng1LocationServices($locationProvider) {
        // .onChange() registry
        this._urlListeners = [];
        this.$locationProvider = $locationProvider;
        var _lp = val($locationProvider);
        createProxyFunctions(_lp, this, _lp, ['hashPrefix']);
    }
    Ng1LocationServices.prototype.dispose = function () { };
    Ng1LocationServices.prototype.onChange = function (callback) {
        var _this = this;
        this._urlListeners.push(callback);
        return function () { return removeFrom(_this._urlListeners)(callback); };
    };
    Ng1LocationServices.prototype.html5Mode = function () {
        var html5Mode = this.$locationProvider.html5Mode();
        html5Mode = isObject(html5Mode) ? html5Mode.enabled : html5Mode;
        return html5Mode && this.$sniffer.history;
    };
    Ng1LocationServices.prototype.url = function (newUrl, replace, state) {
        if (replace === void 0) { replace = false; }
        if (newUrl)
            this.$location.url(newUrl);
        if (replace)
            this.$location.replace();
        if (state)
            this.$location.state(state);
        return this.$location.url();
    };
    Ng1LocationServices.prototype._runtimeServices = function ($rootScope, $location, $sniffer, $browser) {
        var _this = this;
        this.$location = $location;
        this.$sniffer = $sniffer;
        // Bind $locationChangeSuccess to the listeners registered in LocationService.onChange
        $rootScope.$on("$locationChangeSuccess", function (evt) { return _this._urlListeners.forEach(function (fn) { return fn(evt); }); });
        var _loc = val($location);
        var _browser = val($browser);
        // Bind these LocationService functions to $location
        createProxyFunctions(_loc, this, _loc, ["replace", "path", "search", "hash"]);
        // Bind these LocationConfig functions to $location
        createProxyFunctions(_loc, this, _loc, ['port', 'protocol', 'host']);
        // Bind these LocationConfig functions to $browser
        createProxyFunctions(_browser, this, _browser, ['baseHref']);
    };
    /**
     * Applys ng1-specific path parameter encoding
     *
     * The Angular 1 `$location` service is a bit weird.
     * It doesn't allow slashes to be encoded/decoded bi-directionally.
     *
     * See the writeup at https://github.com/angular-ui/ui-router/issues/2598
     *
     * This code patches the `path` parameter type so it encoded/decodes slashes as ~2F
     *
     * @param router
     */
    Ng1LocationServices.monkeyPatchPathParameterType = function (router) {
        var pathType = router.urlMatcherFactory.type('path');
        pathType.encode = function (val) {
            return val != null ? val.toString().replace(/(~|\/)/g, function (m) { return ({ '~': '~~', '/': '~2F' }[m]); }) : val;
        };
        pathType.decode = function (val) {
            return val != null ? val.toString().replace(/(~~|~2F)/g, function (m) { return ({ '~~': '~', '~2F': '/' }[m]); }) : val;
        };
    };
    return Ng1LocationServices;
}());
export { Ng1LocationServices };
//# sourceMappingURL=data:application/json;base64,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