/**
 * # Angular 1 types
 *
 * UI-Router core provides various Typescript types which you can use for code completion and validating parameter values, etc.
 * The customizations to the core types for Angular UI-Router are documented here.
 *
 * The optional [[$resolve]] service is also documented here.
 *
 * @module ng1
 * @preferred
 */
/** for typedoc */
import { ng as angular } from "./angular";
import { services, applyPairs, isString, trace, extend, UIRouter, unnestR } from "@uirouter/core";
import { ng1ViewsBuilder, getNg1ViewConfigFactory } from "./statebuilders/views";
import { TemplateFactory } from "./templateFactory";
import { StateProvider } from "./stateProvider";
import { getStateHookBuilder } from "./statebuilders/onEnterExitRetain";
import { Ng1LocationServices } from "./locationServices";
import { UrlRouterProvider } from "./urlRouterProvider";
angular.module("ui.router.angular1", []);
var mod_init = angular.module('ui.router.init', []);
var mod_util = angular.module('ui.router.util', ['ng', 'ui.router.init']);
var mod_rtr = angular.module('ui.router.router', ['ui.router.util']);
var mod_state = angular.module('ui.router.state', ['ui.router.router', 'ui.router.util', 'ui.router.angular1']);
var mod_main = angular.module('ui.router', ['ui.router.init', 'ui.router.state', 'ui.router.angular1']);
var mod_cmpt = angular.module('ui.router.compat', ['ui.router']); // tslint:disable-line
var router = null;
$uiRouter.$inject = ['$locationProvider'];
/** This angular 1 provider instantiates a Router and exposes its services via the angular injector */
function $uiRouter($locationProvider) {
    // Create a new instance of the Router when the $uiRouterProvider is initialized
    router = this.router = new UIRouter();
    router.stateProvider = new StateProvider(router.stateRegistry, router.stateService);
    // Apply ng1 specific StateBuilder code for `views`, `resolve`, and `onExit/Retain/Enter` properties
    router.stateRegistry.decorator("views", ng1ViewsBuilder);
    router.stateRegistry.decorator("onExit", getStateHookBuilder("onExit"));
    router.stateRegistry.decorator("onRetain", getStateHookBuilder("onRetain"));
    router.stateRegistry.decorator("onEnter", getStateHookBuilder("onEnter"));
    router.viewService._pluginapi._viewConfigFactory('ng1', getNg1ViewConfigFactory());
    var ng1LocationService = router.locationService = router.locationConfig = new Ng1LocationServices($locationProvider);
    Ng1LocationServices.monkeyPatchPathParameterType(router);
    // backwards compat: also expose router instance as $uiRouterProvider.router
    router['router'] = router;
    router['$get'] = $get;
    $get.$inject = ['$location', '$browser', '$sniffer', '$rootScope', '$http', '$templateCache'];
    function $get($location, $browser, $sniffer, $rootScope, $http, $templateCache) {
        ng1LocationService._runtimeServices($rootScope, $location, $sniffer, $browser);
        delete router['router'];
        delete router['$get'];
        return router;
    }
    return router;
}
var getProviderFor = function (serviceName) { return ['$uiRouterProvider', function ($urp) {
        var service = $urp.router[serviceName];
        service["$get"] = function () { return service; };
        return service;
    }]; };
// This effectively calls $get() on `$uiRouterProvider` to trigger init (when ng enters runtime)
runBlock.$inject = ['$injector', '$q', '$uiRouter'];
function runBlock($injector, $q, $uiRouter) {
    services.$injector = $injector;
    services.$q = $q;
    // The $injector is now available.
    // Find any resolvables that had dependency annotation deferred
    $uiRouter.stateRegistry.get()
        .map(function (x) { return x.$$state().resolvables; })
        .reduce(unnestR, [])
        .filter(function (x) { return x.deps === "deferred"; })
        .forEach(function (resolvable) { return resolvable.deps = $injector.annotate(resolvable.resolveFn, $injector.strictDi); });
}
// $urlRouter service and $urlRouterProvider
var getUrlRouterProvider = function (uiRouter) {
    return uiRouter.urlRouterProvider = new UrlRouterProvider(uiRouter);
};
// $state service and $stateProvider
// $urlRouter service and $urlRouterProvider
var getStateProvider = function () {
    return extend(router.stateProvider, { $get: function () { return router.stateService; } });
};
watchDigests.$inject = ['$rootScope'];
export function watchDigests($rootScope) {
    $rootScope.$watch(function () { trace.approximateDigests++; });
}
mod_init.provider("$uiRouter", $uiRouter);
mod_rtr.provider('$urlRouter', ['$uiRouterProvider', getUrlRouterProvider]);
mod_util.provider('$urlService', getProviderFor('urlService'));
mod_util.provider('$urlMatcherFactory', ['$uiRouterProvider', function () { return router.urlMatcherFactory; }]);
mod_util.provider('$templateFactory', function () { return new TemplateFactory(); });
mod_state.provider('$stateRegistry', getProviderFor('stateRegistry'));
mod_state.provider('$uiRouterGlobals', getProviderFor('globals'));
mod_state.provider('$transitions', getProviderFor('transitionService'));
mod_state.provider('$state', ['$uiRouterProvider', getStateProvider]);
mod_state.factory('$stateParams', ['$uiRouter', function ($uiRouter) { return $uiRouter.globals.params; }]);
mod_main.factory('$view', function () { return router.viewService; });
mod_main.service("$trace", function () { return trace; });
mod_main.run(watchDigests);
mod_util.run(['$urlMatcherFactory', function ($urlMatcherFactory) { }]);
mod_state.run(['$state', function ($state) { }]);
mod_rtr.run(['$urlRouter', function ($urlRouter) { }]);
mod_init.run(runBlock);
/** @hidden TODO: find a place to move this */
export var getLocals = function (ctx) {
    var tokens = ctx.getTokens().filter(isString);
    var tuples = tokens.map(function (key) {
        var resolvable = ctx.getResolvable(key);
        var waitPolicy = ctx.getPolicy(resolvable).async;
        return [key, waitPolicy === 'NOWAIT' ? resolvable.promise : resolvable.data];
    });
    return tuples.reduce(applyPairs, {});
};
//# sourceMappingURL=data:application/json;base64,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