/** @module ng1 */ /** for typedoc */
import { ng as angular } from "./angular";
/**
 * `isState` Filter: truthy if the current state is the parameter
 *
 * Translates to [[StateService.is]] `$state.is("stateName")`.
 *
 * #### Example:
 * ```html
 * <div ng-if="'stateName' | isState">show if state is 'stateName'</div>
 * ```
 */
$IsStateFilter.$inject = ['$state'];
export function $IsStateFilter($state) {
    var isFilter = function (state, params, options) {
        return $state.is(state, params, options);
    };
    isFilter.$stateful = true;
    return isFilter;
}
/**
 * `includedByState` Filter: truthy if the current state includes the parameter
 *
 * Translates to [[StateService.includes]]` $state.is("fullOrPartialStateName")`.
 *
 * #### Example:
 * ```html
 * <div ng-if="'fullOrPartialStateName' | includedByState">show if state includes 'fullOrPartialStateName'</div>
 * ```
 */
$IncludedByStateFilter.$inject = ['$state'];
export function $IncludedByStateFilter($state) {
    var includesFilter = function (state, params, options) {
        return $state.includes(state, params, options);
    };
    includesFilter.$stateful = true;
    return includesFilter;
}
angular.module('ui.router.state')
    .filter('isState', $IsStateFilter)
    .filter('includedByState', $IncludedByStateFilter);
//# sourceMappingURL=data:application/json;base64,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