/** @module ng1 */ /** */
import { services, ResolveContext, extend } from "@uirouter/core";
import { getLocals } from "../services";
/**
 * This is a [[StateBuilder.builder]] function for angular1 `onEnter`, `onExit`,
 * `onRetain` callback hooks on a [[Ng1StateDeclaration]].
 *
 * When the [[StateBuilder]] builds a [[StateObject]] object from a raw [[StateDeclaration]], this builder
 * ensures that those hooks are injectable for @uirouter/angularjs (ng1).
 */
export var getStateHookBuilder = function (hookName) {
    return function stateHookBuilder(state, parentFn) {
        var hook = state[hookName];
        var pathname = hookName === 'onExit' ? 'from' : 'to';
        function decoratedNg1Hook(trans, state) {
            var resolveContext = new ResolveContext(trans.treeChanges(pathname));
            var locals = extend(getLocals(resolveContext), { $state$: state, $transition$: trans });
            return services.$injector.invoke(hook, this, locals);
        }
        return hook ? decoratedNg1Hook : undefined;
    };
};
//# sourceMappingURL=data:application/json;base64,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