import { pick, forEach, tail, extend, isArray, isInjectable, isDefined, isString, services, trace, ViewService, ResolveContext, Resolvable } from "@uirouter/core";
export function getNg1ViewConfigFactory() {
    var templateFactory = null;
    return function (path, view) {
        templateFactory = templateFactory || services.$injector.get("$templateFactory");
        return [new Ng1ViewConfig(path, view, templateFactory)];
    };
}
var hasAnyKey = function (keys, obj) {
    return keys.reduce(function (acc, key) { return acc || isDefined(obj[key]); }, false);
};
/**
 * This is a [[StateBuilder.builder]] function for angular1 `views`.
 *
 * When the [[StateBuilder]] builds a [[StateObject]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to @uirouter/angularjs (ng1).
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object
 * and applies the state-level configuration to a view named `$default`.
 */
export function ng1ViewsBuilder(state) {
    // Do not process root state
    if (!state.parent)
        return {};
    var tplKeys = ['templateProvider', 'templateUrl', 'template', 'notify', 'async'], ctrlKeys = ['controller', 'controllerProvider', 'controllerAs', 'resolveAs'], compKeys = ['component', 'bindings', 'componentProvider'], nonCompKeys = tplKeys.concat(ctrlKeys), allViewKeys = compKeys.concat(nonCompKeys);
    // Do not allow a state to have both state-level props and also a `views: {}` property.
    // A state without a `views: {}` property can declare properties for the `$default` view as properties of the state.
    // However, the `$default` approach should not be mixed with a separate `views: ` block.
    if (isDefined(state.views) && hasAnyKey(allViewKeys, state)) {
        throw new Error("State '" + state.name + "' has a 'views' object. " +
            "It cannot also have \"view properties\" at the state level.  " +
            "Move the following properties into a view (in the 'views' object): " +
            (" " + allViewKeys.filter(function (key) { return isDefined(state[key]); }).join(", ")));
    }
    var views = {}, viewsObject = state.views || { "$default": pick(state, allViewKeys) };
    forEach(viewsObject, function (config, name) {
        // Account for views: { "": { template... } }
        name = name || "$default";
        // Account for views: { header: "headerComponent" }
        if (isString(config))
            config = { component: config };
        // Make a shallow copy of the config object
        config = extend({}, config);
        // Do not allow a view to mix props for component-style view with props for template/controller-style view
        if (hasAnyKey(compKeys, config) && hasAnyKey(nonCompKeys, config)) {
            throw new Error("Cannot combine: " + compKeys.join("|") + " with: " + nonCompKeys.join("|") + " in stateview: '" + name + "@" + state.name + "'");
        }
        config.resolveAs = config.resolveAs || '$resolve';
        config.$type = "ng1";
        config.$context = state;
        config.$name = name;
        var normalized = ViewService.normalizeUIViewTarget(config.$context, config.$name);
        config.$uiViewName = normalized.uiViewName;
        config.$uiViewContextAnchor = normalized.uiViewContextAnchor;
        views[name] = config;
    });
    return views;
}
var id = 0;
var Ng1ViewConfig = (function () {
    function Ng1ViewConfig(path, viewDecl, factory) {
        var _this = this;
        this.path = path;
        this.viewDecl = viewDecl;
        this.factory = factory;
        this.$id = id++;
        this.loaded = false;
        this.getTemplate = function (uiView, context) {
            return _this.component ? _this.factory.makeComponentTemplate(uiView, context, _this.component, _this.viewDecl.bindings) : _this.template;
        };
    }
    Ng1ViewConfig.prototype.load = function () {
        var _this = this;
        var $q = services.$q;
        var context = new ResolveContext(this.path);
        var params = this.path.reduce(function (acc, node) { return extend(acc, node.paramValues); }, {});
        var promises = {
            template: $q.when(this.factory.fromConfig(this.viewDecl, params, context)),
            controller: $q.when(this.getController(context))
        };
        return $q.all(promises).then(function (results) {
            trace.traceViewServiceEvent("Loaded", _this);
            _this.controller = results.controller;
            extend(_this, results.template); // Either { template: "tpl" } or { component: "cmpName" }
            return _this;
        });
    };
    /**
     * Gets the controller for a view configuration.
     *
     * @returns {Function|Promise.<Function>} Returns a controller, or a promise that resolves to a controller.
     */
    Ng1ViewConfig.prototype.getController = function (context) {
        var provider = this.viewDecl.controllerProvider;
        if (!isInjectable(provider))
            return this.viewDecl.controller;
        var deps = services.$injector.annotate(provider);
        var providerFn = isArray(provider) ? tail(provider) : provider;
        var resolvable = new Resolvable("", providerFn, deps);
        return resolvable.get(context);
    };
    return Ng1ViewConfig;
}());
export { Ng1ViewConfig };
//# sourceMappingURL=data:application/json;base64,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