"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @ng1api
 * @module directives
 */ /** for typedoc */
var angular_1 = require("../angular");
var angular_2 = require("angular");
var core_1 = require("@uirouter/core");
var views_1 = require("../statebuilders/views");
var services_1 = require("../services");
exports.uiView = ['$view', '$animate', '$uiViewScroll', '$interpolate', '$q',
    function $ViewDirective($view, $animate, $uiViewScroll, $interpolate, $q) {
        function getRenderer(attrs, scope) {
            return {
                enter: function (element, target, cb) {
                    if (angular_1.ng.version.minor > 2) {
                        $animate.enter(element, null, target).then(cb);
                    }
                    else {
                        $animate.enter(element, null, target, cb);
                    }
                },
                leave: function (element, cb) {
                    if (angular_1.ng.version.minor > 2) {
                        $animate.leave(element).then(cb);
                    }
                    else {
                        $animate.leave(element, cb);
                    }
                }
            };
        }
        function configsEqual(config1, config2) {
            return config1 === config2;
        }
        var rootData = {
            $cfg: { viewDecl: { $context: $view._pluginapi._rootViewContext() } },
            $uiView: {}
        };
        var directive = {
            count: 0,
            restrict: 'ECA',
            terminal: true,
            priority: 400,
            transclude: 'element',
            compile: function (tElement, tAttrs, $transclude) {
                return function (scope, $element, attrs) {
                    var previousEl, currentEl, currentScope, unregister, onloadExp = attrs['onload'] || '', autoScrollExp = attrs['autoscroll'], renderer = getRenderer(attrs, scope), viewConfig = undefined, inherited = $element.inheritedData('$uiView') || rootData, name = $interpolate(attrs['uiView'] || attrs['name'] || '')(scope) || '$default';
                    var activeUIView = {
                        $type: 'ng1',
                        id: directive.count++,
                        name: name,
                        fqn: inherited.$uiView.fqn ? inherited.$uiView.fqn + "." + name : name,
                        config: null,
                        configUpdated: configUpdatedCallback,
                        get creationContext() {
                            var fromParentTagConfig = core_1.parse('$cfg.viewDecl.$context')(inherited);
                            // Allow <ui-view name="foo"><ui-view name="bar"></ui-view></ui-view>
                            // See https://github.com/angular-ui/ui-router/issues/3355
                            var fromParentTag = core_1.parse('$uiView.creationContext')(inherited);
                            return fromParentTagConfig || fromParentTag;
                        }
                    };
                    core_1.trace.traceUIViewEvent("Linking", activeUIView);
                    function configUpdatedCallback(config) {
                        if (config && !(config instanceof views_1.Ng1ViewConfig))
                            return;
                        if (configsEqual(viewConfig, config))
                            return;
                        core_1.trace.traceUIViewConfigUpdated(activeUIView, config && config.viewDecl && config.viewDecl.$context);
                        viewConfig = config;
                        updateView(config);
                    }
                    $element.data('$uiView', { $uiView: activeUIView });
                    updateView();
                    unregister = $view.registerUIView(activeUIView);
                    scope.$on("$destroy", function () {
                        core_1.trace.traceUIViewEvent("Destroying/Unregistering", activeUIView);
                        unregister();
                    });
                    function cleanupLastView() {
                        if (previousEl) {
                            core_1.trace.traceUIViewEvent("Removing (previous) el", previousEl.data('$uiView'));
                            previousEl.remove();
                            previousEl = null;
                        }
                        if (currentScope) {
                            core_1.trace.traceUIViewEvent("Destroying scope", activeUIView);
                            currentScope.$destroy();
                            currentScope = null;
                        }
                        if (currentEl) {
                            var _viewData_1 = currentEl.data('$uiViewAnim');
                            core_1.trace.traceUIViewEvent("Animate out", _viewData_1);
                            renderer.leave(currentEl, function () {
                                _viewData_1.$$animLeave.resolve();
                                previousEl = null;
                            });
                            previousEl = currentEl;
                            currentEl = null;
                        }
                    }
                    function updateView(config) {
                        var newScope = scope.$new();
                        var animEnter = $q.defer(), animLeave = $q.defer();
                        var $uiViewData = {
                            $cfg: config,
                            $uiView: activeUIView,
                        };
                        var $uiViewAnim = {
                            $animEnter: animEnter.promise,
                            $animLeave: animLeave.promise,
                            $$animLeave: animLeave
                        };
                        /**
                         * @ngdoc event
                         * @name ui.router.state.directive:ui-view#$viewContentLoading
                         * @eventOf ui.router.state.directive:ui-view
                         * @eventType emits on ui-view directive scope
                         * @description
                         *
                         * Fired once the view **begins loading**, *before* the DOM is rendered.
                         *
                         * @param {Object} event Event object.
                         * @param {string} viewName Name of the view.
                         */
                        newScope.$emit('$viewContentLoading', name);
                        var cloned = $transclude(newScope, function (clone) {
                            clone.data('$uiViewAnim', $uiViewAnim);
                            clone.data('$uiView', $uiViewData);
                            renderer.enter(clone, $element, function onUIViewEnter() {
                                animEnter.resolve();
                                if (currentScope)
                                    currentScope.$emit('$viewContentAnimationEnded');
                                if (core_1.isDefined(autoScrollExp) && !autoScrollExp || scope.$eval(autoScrollExp)) {
                                    $uiViewScroll(clone);
                                }
                            });
                            cleanupLastView();
                        });
                        currentEl = cloned;
                        currentScope = newScope;
                        /**
                         * @ngdoc event
                         * @name ui.router.state.directive:ui-view#$viewContentLoaded
                         * @eventOf ui.router.state.directive:ui-view
                         * @eventType emits on ui-view directive scope
                         * @description           *
                         * Fired once the view is **loaded**, *after* the DOM is rendered.
                         *
                         * @param {Object} event Event object.
                         */
                        currentScope.$emit('$viewContentLoaded', config || viewConfig);
                        currentScope.$eval(onloadExp);
                    }
                };
            }
        };
        return directive;
    }];
$ViewDirectiveFill.$inject = ['$compile', '$controller', '$transitions', '$view', '$q', '$timeout'];
/** @hidden */
function $ViewDirectiveFill($compile, $controller, $transitions, $view, $q, $timeout) {
    var getControllerAs = core_1.parse('viewDecl.controllerAs');
    var getResolveAs = core_1.parse('viewDecl.resolveAs');
    return {
        restrict: 'ECA',
        priority: -400,
        compile: function (tElement) {
            var initial = tElement.html();
            tElement.empty();
            return function (scope, $element) {
                var data = $element.data('$uiView');
                if (!data) {
                    $element.html(initial);
                    $compile($element.contents())(scope);
                    return;
                }
                var cfg = data.$cfg || { viewDecl: {}, getTemplate: angular_2.noop };
                var resolveCtx = cfg.path && new core_1.ResolveContext(cfg.path);
                $element.html(cfg.getTemplate($element, resolveCtx) || initial);
                core_1.trace.traceUIViewFill(data.$uiView, $element.html());
                var link = $compile($element.contents());
                var controller = cfg.controller;
                var controllerAs = getControllerAs(cfg);
                var resolveAs = getResolveAs(cfg);
                var locals = resolveCtx && services_1.getLocals(resolveCtx);
                scope[resolveAs] = locals;
                if (controller) {
                    var controllerInstance = $controller(controller, core_1.extend({}, locals, { $scope: scope, $element: $element }));
                    if (controllerAs) {
                        scope[controllerAs] = controllerInstance;
                        scope[controllerAs][resolveAs] = locals;
                    }
                    // TODO: Use $view service as a central point for registering component-level hooks
                    // Then, when a component is created, tell the $view service, so it can invoke hooks
                    // $view.componentLoaded(controllerInstance, { $scope: scope, $element: $element });
                    // scope.$on('$destroy', () => $view.componentUnloaded(controllerInstance, { $scope: scope, $element: $element }));
                    $element.data('$ngControllerController', controllerInstance);
                    $element.children().data('$ngControllerController', controllerInstance);
                    registerControllerCallbacks($q, $transitions, controllerInstance, scope, cfg);
                }
                // Wait for the component to appear in the DOM
                if (core_1.isString(cfg.viewDecl.component)) {
                    var cmp_1 = cfg.viewDecl.component;
                    var kebobName = core_1.kebobString(cmp_1);
                    var tagRegexp_1 = new RegExp("^(x-|data-)?" + kebobName + "$", "i");
                    var getComponentController = function () {
                        var directiveEl = [].slice.call($element[0].children)
                            .filter(function (el) { return el && el.tagName && tagRegexp_1.exec(el.tagName); });
                        return directiveEl && angular_1.ng.element(directiveEl).data("$" + cmp_1 + "Controller");
                    };
                    var deregisterWatch_1 = scope.$watch(getComponentController, function (ctrlInstance) {
                        if (!ctrlInstance)
                            return;
                        registerControllerCallbacks($q, $transitions, ctrlInstance, scope, cfg);
                        deregisterWatch_1();
                    });
                }
                link(scope);
            };
        }
    };
}
/** @hidden */
var hasComponentImpl = typeof angular_1.ng.module('ui.router')['component'] === 'function';
/** @hidden incrementing id */
var _uiCanExitId = 0;
/** @hidden TODO: move these callbacks to $view and/or `/hooks/components.ts` or something */
function registerControllerCallbacks($q, $transitions, controllerInstance, $scope, cfg) {
    // Call $onInit() ASAP
    if (core_1.isFunction(controllerInstance.$onInit) && !(cfg.viewDecl.component && hasComponentImpl)) {
        controllerInstance.$onInit();
    }
    var viewState = core_1.tail(cfg.path).state.self;
    var hookOptions = { bind: controllerInstance };
    // Add component-level hook for onParamsChange
    if (core_1.isFunction(controllerInstance.uiOnParamsChanged)) {
        var resolveContext = new core_1.ResolveContext(cfg.path);
        var viewCreationTrans_1 = resolveContext.getResolvable('$transition$').data;
        // Fire callback on any successful transition
        var paramsUpdated = function ($transition$) {
            // Exit early if the $transition$ is the same as the view was created within.
            // Exit early if the $transition$ will exit the state the view is for.
            if ($transition$ === viewCreationTrans_1 || $transition$.exiting().indexOf(viewState) !== -1)
                return;
            var toParams = $transition$.params("to");
            var fromParams = $transition$.params("from");
            var toSchema = $transition$.treeChanges().to.map(function (node) { return node.paramSchema; }).reduce(core_1.unnestR, []);
            var fromSchema = $transition$.treeChanges().from.map(function (node) { return node.paramSchema; }).reduce(core_1.unnestR, []);
            // Find the to params that have different values than the from params
            var changedToParams = toSchema.filter(function (param) {
                var idx = fromSchema.indexOf(param);
                return idx === -1 || !fromSchema[idx].type.equals(toParams[param.id], fromParams[param.id]);
            });
            // Only trigger callback if a to param has changed or is new
            if (changedToParams.length) {
                var changedKeys_1 = changedToParams.map(function (x) { return x.id; });
                // Filter the params to only changed/new to params.  `$transition$.params()` may be used to get all params.
                var newValues = core_1.filter(toParams, function (val, key) { return changedKeys_1.indexOf(key) !== -1; });
                controllerInstance.uiOnParamsChanged(newValues, $transition$);
            }
        };
        $scope.$on('$destroy', $transitions.onSuccess({}, paramsUpdated, hookOptions));
    }
    // Add component-level hook for uiCanExit
    if (core_1.isFunction(controllerInstance.uiCanExit)) {
        var id_1 = _uiCanExitId++;
        var cacheProp_1 = '_uiCanExitIds';
        // Returns true if a redirect transition already answered truthy
        var prevTruthyAnswer_1 = function (trans) {
            return !!trans && (trans[cacheProp_1] && trans[cacheProp_1][id_1] === true || prevTruthyAnswer_1(trans.redirectedFrom()));
        };
        // If a user answered yes, but the transition was later redirected, don't also ask for the new redirect transition
        var wrappedHook = function (trans) {
            var promise, ids = trans[cacheProp_1] = trans[cacheProp_1] || {};
            if (!prevTruthyAnswer_1(trans)) {
                promise = $q.when(controllerInstance.uiCanExit(trans));
                promise.then(function (val) { return ids[id_1] = (val !== false); });
            }
            return promise;
        };
        var criteria = { exiting: viewState.name };
        $scope.$on('$destroy', $transitions.onBefore(criteria, wrappedHook, hookOptions));
    }
}
angular_1.ng.module('ui.router.state').directive('uiView', exports.uiView);
angular_1.ng.module('ui.router.state').directive('uiView', $ViewDirectiveFill);
//# sourceMappingURL=data:application/json;base64,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