"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @module ng1 */ /** */
var core_1 = require("@uirouter/core");
var angular = require("angular");
/**
 * Implementation of the legacy `$resolve` service for angular 1.
 */
var $resolve = {
    /**
     * Asynchronously injects a resolve block.
     *
     * This emulates most of the behavior of the ui-router 0.2.x $resolve.resolve() service API.
     *
    * ### Not bundled by default
     *
     * This API is no longer not part of the standard `@uirouter/angularjs` bundle.
     * For users of the prebuilt bundles, add the `release/resolveService.min.js` UMD bundle.
     * For bundlers (webpack, browserify, etc), add `@uirouter/angularjs/lib/legacy/resolveService`.
     *
     * ---
     *
     * Given an object `invocables`, where keys are strings and values are injectable functions,
     * injects each function, and waits for the resulting promise to resolve.
     * When all resulting promises are resolved, returns the results as an object.
     *
     * #### Example:
     * ```js
     * let invocables = {
     *   foo: [ '$http', ($http) =>
     *            $http.get('/api/foo').then(resp => resp.data) ],
     *   bar: [ 'foo', '$http', (foo, $http) =>
     *            $http.get('/api/bar/' + foo.barId).then(resp => resp.data) ]
     * }
     * $resolve.resolve(invocables)
     *     .then(results => console.log(results.foo, results.bar))
     * // Logs foo and bar:
     * // { id: 123, barId: 456, fooData: 'foo data' }
     * // { id: 456, barData: 'bar data' }
     * ```
     *
     * @param invocables an object which looks like an [[StateDeclaration.resolve]] object; keys are resolve names and values are injectable functions
     * @param locals key/value pre-resolved data (locals)
     * @param parent a promise for a "parent resolve"
     */
    resolve: function (invocables, locals, parent) {
        if (locals === void 0) { locals = {}; }
        var parentNode = new core_1.PathNode(new core_1.StateObject({ params: {}, resolvables: [] }));
        var node = new core_1.PathNode(new core_1.StateObject({ params: {}, resolvables: [] }));
        var context = new core_1.ResolveContext([parentNode, node]);
        context.addResolvables(core_1.resolvablesBuilder({ resolve: invocables }), node.state);
        var resolveData = function (parentLocals) {
            var rewrap = function (_locals) { return core_1.resolvablesBuilder({ resolve: core_1.mapObj(_locals, function (local) { return function () { return local; }; }) }); };
            context.addResolvables(rewrap(parentLocals), parentNode.state);
            context.addResolvables(rewrap(locals), node.state);
            var tuples2ObjR = function (acc, tuple) {
                acc[tuple.token] = tuple.value;
                return acc;
            };
            return context.resolvePath().then(function (results) { return results.reduce(tuples2ObjR, {}); });
        };
        return parent ? parent.then(resolveData) : resolveData({});
    }
};
/** @hidden */
exports.resolveFactory = function () { return $resolve; };
// The old $resolve service
angular.module('ui.router').factory('$resolve', exports.resolveFactory);
//# sourceMappingURL=data:application/json;base64,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