"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * # Legacy state events
 *
 * Polyfill implementation of the UI-Router 0.2.x state events.
 *
 * The 0.2.x state events are deprecated.  We recommend moving to Transition Hooks instead, as they
 * provide much more flexibility, support async, and provide the context (the Transition, etc) necessary
 * to implement meaningful application behaviors.
 *
 * To enable these state events, include the `stateEvents.js` file in your project, e.g.,
 * ```
 * <script src="stateEvents.js"></script>
 * ```
 * and also make sure you depend on the `ui.router.state.events` angular module, e.g.,
 * ```
 * angular.module("myApplication", ['ui.router', 'ui.router.state.events']
 * ```
 *
 * @module ng1_state_events
 */ /** */
var angular_1 = require("../angular");
(function () {
    var isFunction = angular_1.ng.isFunction, isString = angular_1.ng.isString;
    function applyPairs(memo, keyValTuple) {
        var key, value;
        if (Array.isArray(keyValTuple))
            key = keyValTuple[0], value = keyValTuple[1];
        if (!isString(key))
            throw new Error("invalid parameters to applyPairs");
        memo[key] = value;
        return memo;
    }
    function stateChangeStartHandler($transition$) {
        if (!$transition$.options().notify || !$transition$.valid() || $transition$.ignored())
            return;
        var $injector = $transition$.injector();
        var $stateEvents = $injector.get('$stateEvents');
        var $rootScope = $injector.get('$rootScope');
        var $state = $injector.get('$state');
        var $urlRouter = $injector.get('$urlRouter');
        var enabledEvents = $stateEvents.provider.enabled();
        var toParams = $transition$.params("to");
        var fromParams = $transition$.params("from");
        if (enabledEvents.$stateChangeSuccess) {
            var startEvent = $rootScope.$broadcast('$stateChangeStart', $transition$.to(), toParams, $transition$.from(), fromParams, $transition$.options(), $transition$);
            if (startEvent.defaultPrevented) {
                if (enabledEvents.$stateChangeCancel) {
                    $rootScope.$broadcast('$stateChangeCancel', $transition$.to(), toParams, $transition$.from(), fromParams, $transition$.options(), $transition$);
                }
                //Don't update and resync url if there's been a new transition started. see issue #2238, #600
                if ($state.transition == null)
                    $urlRouter.update();
                return false;
            }
            // right after global state is updated
            var successOpts = { priority: 9999 };
            $transition$.onSuccess({}, function () {
                $rootScope.$broadcast('$stateChangeSuccess', $transition$.to(), toParams, $transition$.from(), fromParams, $transition$.options(), $transition$);
            }, successOpts);
        }
        if (enabledEvents.$stateChangeError) {
            $transition$.promise["catch"](function (error) {
                if (error && (error.type === 2 /* RejectType.SUPERSEDED */ || error.type === 3 /* RejectType.ABORTED */))
                    return;
                var evt = $rootScope.$broadcast('$stateChangeError', $transition$.to(), toParams, $transition$.from(), fromParams, error, $transition$.options(), $transition$);
                if (!evt.defaultPrevented) {
                    $urlRouter.update();
                }
            });
        }
    }
    stateNotFoundHandler.$inject = ['$to$', '$from$', '$state', '$rootScope', '$urlRouter'];
    function stateNotFoundHandler($to$, $from$, injector) {
        var $state = injector.get('$state');
        var $rootScope = injector.get('$rootScope');
        var $urlRouter = injector.get('$urlRouter');
        var redirect = { to: $to$.identifier(), toParams: $to$.params(), options: $to$.options() };
        var e = $rootScope.$broadcast('$stateNotFound', redirect, $from$.state(), $from$.params());
        if (e.defaultPrevented || e.retry)
            $urlRouter.update();
        function redirectFn() {
            return $state.target(redirect.to, redirect.toParams, redirect.options);
        }
        if (e.defaultPrevented) {
            return false;
        }
        else if (e.retry || !!$state.get(redirect.to)) {
            return e.retry && isFunction(e.retry.then) ? e.retry.then(redirectFn) : redirectFn();
        }
    }
    $StateEventsProvider.$inject = ['$stateProvider'];
    function $StateEventsProvider($stateProvider) {
        $StateEventsProvider.prototype.instance = this;
        var runtime = false;
        var allEvents = ['$stateChangeStart', '$stateNotFound', '$stateChangeSuccess', '$stateChangeError'];
        var enabledStateEvents = allEvents.map(function (e) { return [e, true]; }).reduce(applyPairs, {});
        function assertNotRuntime() {
            if (runtime)
                throw new Error("Cannot enable events at runtime (use $stateEventsProvider");
        }
        /**
         * Enables the deprecated UI-Router 0.2.x State Events
         * [ '$stateChangeStart', '$stateNotFound', '$stateChangeSuccess', '$stateChangeError' ]
         */
        this.enable = function () {
            var events = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                events[_i] = arguments[_i];
            }
            assertNotRuntime();
            if (!events || !events.length)
                events = allEvents;
            events.forEach(function (event) { return enabledStateEvents[event] = true; });
        };
        /**
         * Disables the deprecated UI-Router 0.2.x State Events
         * [ '$stateChangeStart', '$stateNotFound', '$stateChangeSuccess', '$stateChangeError' ]
         */
        this.disable = function () {
            var events = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                events[_i] = arguments[_i];
            }
            assertNotRuntime();
            if (!events || !events.length)
                events = allEvents;
            events.forEach(function (event) { return delete enabledStateEvents[event]; });
        };
        this.enabled = function () { return enabledStateEvents; };
        this.$get = $get;
        $get.$inject = ['$transitions'];
        function $get($transitions) {
            runtime = true;
            if (enabledStateEvents["$stateNotFound"])
                $stateProvider.onInvalid(stateNotFoundHandler);
            if (enabledStateEvents.$stateChangeStart)
                $transitions.onBefore({}, stateChangeStartHandler, { priority: 1000 });
            return {
                provider: $StateEventsProvider.prototype.instance
            };
        }
    }
    angular_1.ng.module('ui.router.state.events', ['ui.router.state'])
        .provider("$stateEvents", $StateEventsProvider)
        .run(['$stateEvents', function ($stateEvents) {
        }]);
})();
//# sourceMappingURL=data:application/json;base64,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