"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@uirouter/core");
/**
 * Implements UI-Router LocationServices and LocationConfig using Angular 1's $location service
 */
var Ng1LocationServices = (function () {
    function Ng1LocationServices($locationProvider) {
        // .onChange() registry
        this._urlListeners = [];
        this.$locationProvider = $locationProvider;
        var _lp = core_1.val($locationProvider);
        core_1.createProxyFunctions(_lp, this, _lp, ['hashPrefix']);
    }
    Ng1LocationServices.prototype.dispose = function () { };
    Ng1LocationServices.prototype.onChange = function (callback) {
        var _this = this;
        this._urlListeners.push(callback);
        return function () { return core_1.removeFrom(_this._urlListeners)(callback); };
    };
    Ng1LocationServices.prototype.html5Mode = function () {
        var html5Mode = this.$locationProvider.html5Mode();
        html5Mode = core_1.isObject(html5Mode) ? html5Mode.enabled : html5Mode;
        return html5Mode && this.$sniffer.history;
    };
    Ng1LocationServices.prototype.url = function (newUrl, replace, state) {
        if (replace === void 0) { replace = false; }
        if (newUrl)
            this.$location.url(newUrl);
        if (replace)
            this.$location.replace();
        if (state)
            this.$location.state(state);
        return this.$location.url();
    };
    Ng1LocationServices.prototype._runtimeServices = function ($rootScope, $location, $sniffer, $browser) {
        var _this = this;
        this.$location = $location;
        this.$sniffer = $sniffer;
        // Bind $locationChangeSuccess to the listeners registered in LocationService.onChange
        $rootScope.$on("$locationChangeSuccess", function (evt) { return _this._urlListeners.forEach(function (fn) { return fn(evt); }); });
        var _loc = core_1.val($location);
        var _browser = core_1.val($browser);
        // Bind these LocationService functions to $location
        core_1.createProxyFunctions(_loc, this, _loc, ["replace", "path", "search", "hash"]);
        // Bind these LocationConfig functions to $location
        core_1.createProxyFunctions(_loc, this, _loc, ['port', 'protocol', 'host']);
        // Bind these LocationConfig functions to $browser
        core_1.createProxyFunctions(_browser, this, _browser, ['baseHref']);
    };
    /**
     * Applys ng1-specific path parameter encoding
     *
     * The Angular 1 `$location` service is a bit weird.
     * It doesn't allow slashes to be encoded/decoded bi-directionally.
     *
     * See the writeup at https://github.com/angular-ui/ui-router/issues/2598
     *
     * This code patches the `path` parameter type so it encoded/decodes slashes as ~2F
     *
     * @param router
     */
    Ng1LocationServices.monkeyPatchPathParameterType = function (router) {
        var pathType = router.urlMatcherFactory.type('path');
        pathType.encode = function (val) {
            return val != null ? val.toString().replace(/(~|\/)/g, function (m) { return ({ '~': '~~', '/': '~2F' }[m]); }) : val;
        };
        pathType.decode = function (val) {
            return val != null ? val.toString().replace(/(~~|~2F)/g, function (m) { return ({ '~~': '~', '~2F': '/' }[m]); }) : val;
        };
    };
    return Ng1LocationServices;
}());
exports.Ng1LocationServices = Ng1LocationServices;
//# sourceMappingURL=data:application/json;base64,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