"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * # Angular 1 types
 *
 * UI-Router core provides various Typescript types which you can use for code completion and validating parameter values, etc.
 * The customizations to the core types for Angular UI-Router are documented here.
 *
 * The optional [[$resolve]] service is also documented here.
 *
 * @module ng1
 * @preferred
 */
/** for typedoc */
var angular_1 = require("./angular");
var core_1 = require("@uirouter/core");
var views_1 = require("./statebuilders/views");
var templateFactory_1 = require("./templateFactory");
var stateProvider_1 = require("./stateProvider");
var onEnterExitRetain_1 = require("./statebuilders/onEnterExitRetain");
var locationServices_1 = require("./locationServices");
var urlRouterProvider_1 = require("./urlRouterProvider");
angular_1.ng.module("ui.router.angular1", []);
var mod_init = angular_1.ng.module('ui.router.init', []);
var mod_util = angular_1.ng.module('ui.router.util', ['ng', 'ui.router.init']);
var mod_rtr = angular_1.ng.module('ui.router.router', ['ui.router.util']);
var mod_state = angular_1.ng.module('ui.router.state', ['ui.router.router', 'ui.router.util', 'ui.router.angular1']);
var mod_main = angular_1.ng.module('ui.router', ['ui.router.init', 'ui.router.state', 'ui.router.angular1']);
var mod_cmpt = angular_1.ng.module('ui.router.compat', ['ui.router']); // tslint:disable-line
var router = null;
$uiRouter.$inject = ['$locationProvider'];
/** This angular 1 provider instantiates a Router and exposes its services via the angular injector */
function $uiRouter($locationProvider) {
    // Create a new instance of the Router when the $uiRouterProvider is initialized
    router = this.router = new core_1.UIRouter();
    router.stateProvider = new stateProvider_1.StateProvider(router.stateRegistry, router.stateService);
    // Apply ng1 specific StateBuilder code for `views`, `resolve`, and `onExit/Retain/Enter` properties
    router.stateRegistry.decorator("views", views_1.ng1ViewsBuilder);
    router.stateRegistry.decorator("onExit", onEnterExitRetain_1.getStateHookBuilder("onExit"));
    router.stateRegistry.decorator("onRetain", onEnterExitRetain_1.getStateHookBuilder("onRetain"));
    router.stateRegistry.decorator("onEnter", onEnterExitRetain_1.getStateHookBuilder("onEnter"));
    router.viewService._pluginapi._viewConfigFactory('ng1', views_1.getNg1ViewConfigFactory());
    var ng1LocationService = router.locationService = router.locationConfig = new locationServices_1.Ng1LocationServices($locationProvider);
    locationServices_1.Ng1LocationServices.monkeyPatchPathParameterType(router);
    // backwards compat: also expose router instance as $uiRouterProvider.router
    router['router'] = router;
    router['$get'] = $get;
    $get.$inject = ['$location', '$browser', '$sniffer', '$rootScope', '$http', '$templateCache'];
    function $get($location, $browser, $sniffer, $rootScope, $http, $templateCache) {
        ng1LocationService._runtimeServices($rootScope, $location, $sniffer, $browser);
        delete router['router'];
        delete router['$get'];
        return router;
    }
    return router;
}
var getProviderFor = function (serviceName) { return ['$uiRouterProvider', function ($urp) {
        var service = $urp.router[serviceName];
        service["$get"] = function () { return service; };
        return service;
    }]; };
// This effectively calls $get() on `$uiRouterProvider` to trigger init (when ng enters runtime)
runBlock.$inject = ['$injector', '$q', '$uiRouter'];
function runBlock($injector, $q, $uiRouter) {
    core_1.services.$injector = $injector;
    core_1.services.$q = $q;
    // The $injector is now available.
    // Find any resolvables that had dependency annotation deferred
    $uiRouter.stateRegistry.get()
        .map(function (x) { return x.$$state().resolvables; })
        .reduce(core_1.unnestR, [])
        .filter(function (x) { return x.deps === "deferred"; })
        .forEach(function (resolvable) { return resolvable.deps = $injector.annotate(resolvable.resolveFn, $injector.strictDi); });
}
// $urlRouter service and $urlRouterProvider
var getUrlRouterProvider = function (uiRouter) {
    return uiRouter.urlRouterProvider = new urlRouterProvider_1.UrlRouterProvider(uiRouter);
};
// $state service and $stateProvider
// $urlRouter service and $urlRouterProvider
var getStateProvider = function () {
    return core_1.extend(router.stateProvider, { $get: function () { return router.stateService; } });
};
watchDigests.$inject = ['$rootScope'];
function watchDigests($rootScope) {
    $rootScope.$watch(function () { core_1.trace.approximateDigests++; });
}
exports.watchDigests = watchDigests;
mod_init.provider("$uiRouter", $uiRouter);
mod_rtr.provider('$urlRouter', ['$uiRouterProvider', getUrlRouterProvider]);
mod_util.provider('$urlService', getProviderFor('urlService'));
mod_util.provider('$urlMatcherFactory', ['$uiRouterProvider', function () { return router.urlMatcherFactory; }]);
mod_util.provider('$templateFactory', function () { return new templateFactory_1.TemplateFactory(); });
mod_state.provider('$stateRegistry', getProviderFor('stateRegistry'));
mod_state.provider('$uiRouterGlobals', getProviderFor('globals'));
mod_state.provider('$transitions', getProviderFor('transitionService'));
mod_state.provider('$state', ['$uiRouterProvider', getStateProvider]);
mod_state.factory('$stateParams', ['$uiRouter', function ($uiRouter) { return $uiRouter.globals.params; }]);
mod_main.factory('$view', function () { return router.viewService; });
mod_main.service("$trace", function () { return core_1.trace; });
mod_main.run(watchDigests);
mod_util.run(['$urlMatcherFactory', function ($urlMatcherFactory) { }]);
mod_state.run(['$state', function ($state) { }]);
mod_rtr.run(['$urlRouter', function ($urlRouter) { }]);
mod_init.run(runBlock);
/** @hidden TODO: find a place to move this */
exports.getLocals = function (ctx) {
    var tokens = ctx.getTokens().filter(core_1.isString);
    var tuples = tokens.map(function (key) {
        var resolvable = ctx.getResolvable(key);
        var waitPolicy = ctx.getPolicy(resolvable).async;
        return [key, waitPolicy === 'NOWAIT' ? resolvable.promise : resolvable.data];
    });
    return tuples.reduce(core_1.applyPairs, {});
};
//# sourceMappingURL=data:application/json;base64,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