"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @module ng1 */ /** */
var core_1 = require("@uirouter/core");
var services_1 = require("../services");
/**
 * This is a [[StateBuilder.builder]] function for angular1 `onEnter`, `onExit`,
 * `onRetain` callback hooks on a [[Ng1StateDeclaration]].
 *
 * When the [[StateBuilder]] builds a [[StateObject]] object from a raw [[StateDeclaration]], this builder
 * ensures that those hooks are injectable for @uirouter/angularjs (ng1).
 */
exports.getStateHookBuilder = function (hookName) {
    return function stateHookBuilder(state, parentFn) {
        var hook = state[hookName];
        var pathname = hookName === 'onExit' ? 'from' : 'to';
        function decoratedNg1Hook(trans, state) {
            var resolveContext = new core_1.ResolveContext(trans.treeChanges(pathname));
            var locals = core_1.extend(services_1.getLocals(resolveContext), { $state$: state, $transition$: trans });
            return core_1.services.$injector.invoke(hook, this, locals);
        }
        return hook ? decoratedNg1Hook : undefined;
    };
};
//# sourceMappingURL=data:application/json;base64,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