"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@uirouter/core");
function getNg1ViewConfigFactory() {
    var templateFactory = null;
    return function (path, view) {
        templateFactory = templateFactory || core_1.services.$injector.get("$templateFactory");
        return [new Ng1ViewConfig(path, view, templateFactory)];
    };
}
exports.getNg1ViewConfigFactory = getNg1ViewConfigFactory;
var hasAnyKey = function (keys, obj) {
    return keys.reduce(function (acc, key) { return acc || core_1.isDefined(obj[key]); }, false);
};
/**
 * This is a [[StateBuilder.builder]] function for angular1 `views`.
 *
 * When the [[StateBuilder]] builds a [[StateObject]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to @uirouter/angularjs (ng1).
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object
 * and applies the state-level configuration to a view named `$default`.
 */
function ng1ViewsBuilder(state) {
    // Do not process root state
    if (!state.parent)
        return {};
    var tplKeys = ['templateProvider', 'templateUrl', 'template', 'notify', 'async'], ctrlKeys = ['controller', 'controllerProvider', 'controllerAs', 'resolveAs'], compKeys = ['component', 'bindings', 'componentProvider'], nonCompKeys = tplKeys.concat(ctrlKeys), allViewKeys = compKeys.concat(nonCompKeys);
    // Do not allow a state to have both state-level props and also a `views: {}` property.
    // A state without a `views: {}` property can declare properties for the `$default` view as properties of the state.
    // However, the `$default` approach should not be mixed with a separate `views: ` block.
    if (core_1.isDefined(state.views) && hasAnyKey(allViewKeys, state)) {
        throw new Error("State '" + state.name + "' has a 'views' object. " +
            "It cannot also have \"view properties\" at the state level.  " +
            "Move the following properties into a view (in the 'views' object): " +
            (" " + allViewKeys.filter(function (key) { return core_1.isDefined(state[key]); }).join(", ")));
    }
    var views = {}, viewsObject = state.views || { "$default": core_1.pick(state, allViewKeys) };
    core_1.forEach(viewsObject, function (config, name) {
        // Account for views: { "": { template... } }
        name = name || "$default";
        // Account for views: { header: "headerComponent" }
        if (core_1.isString(config))
            config = { component: config };
        // Make a shallow copy of the config object
        config = core_1.extend({}, config);
        // Do not allow a view to mix props for component-style view with props for template/controller-style view
        if (hasAnyKey(compKeys, config) && hasAnyKey(nonCompKeys, config)) {
            throw new Error("Cannot combine: " + compKeys.join("|") + " with: " + nonCompKeys.join("|") + " in stateview: '" + name + "@" + state.name + "'");
        }
        config.resolveAs = config.resolveAs || '$resolve';
        config.$type = "ng1";
        config.$context = state;
        config.$name = name;
        var normalized = core_1.ViewService.normalizeUIViewTarget(config.$context, config.$name);
        config.$uiViewName = normalized.uiViewName;
        config.$uiViewContextAnchor = normalized.uiViewContextAnchor;
        views[name] = config;
    });
    return views;
}
exports.ng1ViewsBuilder = ng1ViewsBuilder;
var id = 0;
var Ng1ViewConfig = (function () {
    function Ng1ViewConfig(path, viewDecl, factory) {
        var _this = this;
        this.path = path;
        this.viewDecl = viewDecl;
        this.factory = factory;
        this.$id = id++;
        this.loaded = false;
        this.getTemplate = function (uiView, context) {
            return _this.component ? _this.factory.makeComponentTemplate(uiView, context, _this.component, _this.viewDecl.bindings) : _this.template;
        };
    }
    Ng1ViewConfig.prototype.load = function () {
        var _this = this;
        var $q = core_1.services.$q;
        var context = new core_1.ResolveContext(this.path);
        var params = this.path.reduce(function (acc, node) { return core_1.extend(acc, node.paramValues); }, {});
        var promises = {
            template: $q.when(this.factory.fromConfig(this.viewDecl, params, context)),
            controller: $q.when(this.getController(context))
        };
        return $q.all(promises).then(function (results) {
            core_1.trace.traceViewServiceEvent("Loaded", _this);
            _this.controller = results.controller;
            core_1.extend(_this, results.template); // Either { template: "tpl" } or { component: "cmpName" }
            return _this;
        });
    };
    /**
     * Gets the controller for a view configuration.
     *
     * @returns {Function|Promise.<Function>} Returns a controller, or a promise that resolves to a controller.
     */
    Ng1ViewConfig.prototype.getController = function (context) {
        var provider = this.viewDecl.controllerProvider;
        if (!core_1.isInjectable(provider))
            return this.viewDecl.controller;
        var deps = core_1.services.$injector.annotate(provider);
        var providerFn = core_1.isArray(provider) ? core_1.tail(provider) : provider;
        var resolvable = new core_1.Resolvable("", providerFn, deps);
        return resolvable.get(context);
    };
    return Ng1ViewConfig;
}());
exports.Ng1ViewConfig = Ng1ViewConfig;
//# sourceMappingURL=data:application/json;base64,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