"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @module url */ /** */
var core_1 = require("@uirouter/core");
var core_2 = require("@uirouter/core");
/**
 * Manages rules for client-side URL
 *
 * ### Deprecation warning:
 * This class is now considered to be an internal API
 * Use the [[UrlService]] instead.
 * For configuring URL rules, use the [[UrlRulesApi]] which can be found as [[UrlService.rules]].
 *
 * This class manages the router rules for what to do when the URL changes.
 *
 * This provider remains for backwards compatibility.
 *
 * @deprecated
 */
var UrlRouterProvider = (function () {
    /** @hidden */
    function UrlRouterProvider(router) {
        this._router = router;
        this._urlRouter = router.urlRouter;
    }
    /** @hidden */
    UrlRouterProvider.prototype.$get = function () {
        var urlRouter = this._urlRouter;
        urlRouter.update(true);
        if (!urlRouter.interceptDeferred)
            urlRouter.listen();
        return urlRouter;
    };
    /**
     * Registers a url handler function.
     *
     * Registers a low level url handler (a `rule`).
     * A rule detects specific URL patterns and returns a redirect, or performs some action.
     *
     * If a rule returns a string, the URL is replaced with the string, and all rules are fired again.
     *
     * #### Example:
     * ```js
     * var app = angular.module('app', ['ui.router.router']);
     *
     * app.config(function ($urlRouterProvider) {
     *   // Here's an example of how you might allow case insensitive urls
     *   $urlRouterProvider.rule(function ($injector, $location) {
     *     var path = $location.path(),
     *         normalized = path.toLowerCase();
     *
     *     if (path !== normalized) {
     *       return normalized;
     *     }
     *   });
     * });
     * ```
     *
     * @param ruleFn
     * Handler function that takes `$injector` and `$location` services as arguments.
     * You can use them to detect a url and return a different url as a string.
     *
     * @return [[UrlRouterProvider]] (`this`)
     */
    UrlRouterProvider.prototype.rule = function (ruleFn) {
        var _this = this;
        if (!core_2.isFunction(ruleFn))
            throw new Error("'rule' must be a function");
        var match = function () {
            return ruleFn(core_2.services.$injector, _this._router.locationService);
        };
        var rule = new core_1.BaseUrlRule(match, core_2.identity);
        this._urlRouter.rule(rule);
        return this;
    };
    ;
    /**
     * Defines the path or behavior to use when no url can be matched.
     *
     * #### Example:
     * ```js
     * var app = angular.module('app', ['ui.router.router']);
     *
     * app.config(function ($urlRouterProvider) {
     *   // if the path doesn't match any of the urls you configured
     *   // otherwise will take care of routing the user to the
     *   // specified url
     *   $urlRouterProvider.otherwise('/index');
     *
     *   // Example of using function rule as param
     *   $urlRouterProvider.otherwise(function ($injector, $location) {
     *     return '/a/valid/url';
     *   });
     * });
     * ```
     *
     * @param rule
     * The url path you want to redirect to or a function rule that returns the url path or performs a `$state.go()`.
     * The function version is passed two params: `$injector` and `$location` services, and should return a url string.
     *
     * @return {object} `$urlRouterProvider` - `$urlRouterProvider` instance
     */
    UrlRouterProvider.prototype.otherwise = function (rule) {
        var _this = this;
        var urlRouter = this._urlRouter;
        if (core_2.isString(rule)) {
            urlRouter.otherwise(rule);
        }
        else if (core_2.isFunction(rule)) {
            urlRouter.otherwise(function () { return rule(core_2.services.$injector, _this._router.locationService); });
        }
        else {
            throw new Error("'rule' must be a string or function");
        }
        return this;
    };
    ;
    /**
     * Registers a handler for a given url matching.
     *
     * If the handler is a string, it is
     * treated as a redirect, and is interpolated according to the syntax of match
     * (i.e. like `String.replace()` for `RegExp`, or like a `UrlMatcher` pattern otherwise).
     *
     * If the handler is a function, it is injectable.
     * It gets invoked if `$location` matches.
     * You have the option of inject the match object as `$match`.
     *
     * The handler can return
     *
     * - **falsy** to indicate that the rule didn't match after all, then `$urlRouter`
     *   will continue trying to find another one that matches.
     * - **string** which is treated as a redirect and passed to `$location.url()`
     * - **void** or any **truthy** value tells `$urlRouter` that the url was handled.
     *
     * #### Example:
     * ```js
     * var app = angular.module('app', ['ui.router.router']);
     *
     * app.config(function ($urlRouterProvider) {
     *   $urlRouterProvider.when($state.url, function ($match, $stateParams) {
     *     if ($state.$current.navigable !== state ||
     *         !equalForKeys($match, $stateParams) {
     *      $state.transitionTo(state, $match, false);
     *     }
     *   });
     * });
     * ```
     *
     * @param what A pattern string to match, compiled as a [[UrlMatcher]].
     * @param handler The path (or function that returns a path) that you want to redirect your user to.
     * @param ruleCallback [optional] A callback that receives the `rule` registered with [[UrlMatcher.rule]]
     *
     * Note: the handler may also invoke arbitrary code, such as `$state.go()`
     */
    UrlRouterProvider.prototype.when = function (what, handler) {
        if (core_2.isArray(handler) || core_2.isFunction(handler)) {
            handler = UrlRouterProvider.injectableHandler(this._router, handler);
        }
        this._urlRouter.when(what, handler);
        return this;
    };
    ;
    UrlRouterProvider.injectableHandler = function (router, handler) {
        return function (match) {
            return core_2.services.$injector.invoke(handler, null, { $match: match, $stateParams: router.globals.params });
        };
    };
    /**
     * Disables monitoring of the URL.
     *
     * Call this method before UI-Router has bootstrapped.
     * It will stop UI-Router from performing the initial url sync.
     *
     * This can be useful to perform some asynchronous initialization before the router starts.
     * Once the initialization is complete, call [[listen]] to tell UI-Router to start watching and synchronizing the URL.
     *
     * #### Example:
     * ```js
     * var app = angular.module('app', ['ui.router']);
     *
     * app.config(function ($urlRouterProvider) {
     *   // Prevent $urlRouter from automatically intercepting URL changes;
     *   $urlRouterProvider.deferIntercept();
     * })
     *
     * app.run(function (MyService, $urlRouter, $http) {
     *   $http.get("/stuff").then(function(resp) {
     *     MyService.doStuff(resp.data);
     *     $urlRouter.listen();
     *     $urlRouter.sync();
     *   });
     * });
     * ```
     *
     * @param defer Indicates whether to defer location change interception.
     *        Passing no parameter is equivalent to `true`.
     */
    UrlRouterProvider.prototype.deferIntercept = function (defer) {
        this._urlRouter.deferIntercept(defer);
    };
    ;
    return UrlRouterProvider;
}());
exports.UrlRouterProvider = UrlRouterProvider;
//# sourceMappingURL=data:application/json;base64,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