import { UIRouter, RawParams, StateOrName, TargetState, UIRouterPlugin, TransitionService, StateService } from '@uirouter/core';
declare class DSRPlugin implements UIRouterPlugin {
    name: string;
    $transitions: TransitionService;
    $state: StateService;
    hookDeregFns: any[];
    constructor($uiRouter: UIRouter);
    dispose(router: UIRouter): void;
    /**
     * Resets deep state redirect
     *
     * A deep state is recorded for each DSR state.
     * This function resets recorded deep state redirect(s) to the initial value.
     *
     * If called with no parameters, the redirects for all states are reset.
     *
     * If called with a `state` parameter, the redirect for that state is reset.
     *
     * If called with `state` and `params` parameters, the redirect for that state and set of parameter values is reset.
     *
     * @param state (optional) the redirect for this state will be reset
     * @param params (optional) the redirect for the state and parameters will be reset
     */
    reset(state?: StateOrName, params?: RawParams): void;
    /**
     * Returns the recorded redirect
     *
     * Returns the recorded redirect for a given DSR `state` (and optionally `params`).
     *
     * @param state the DSR state
     * @param params (optional) the parameter values
     *
     * @returns the recorded redirect `TargetState`
     */
    getRedirect(state: StateOrName, params?: RawParams): TargetState;
    private getDsrProp(state);
    private getConfig(state);
    private paramsEqual(state, transParams, paramPredicate?, negate?);
    private recordDeepState(transition, state);
    private deepStateRedirect(transition);
    private getDeepStateRedirect(stateOrName, params);
}
export { DSRPlugin };
