/** @packageDocumentation @reactapi @module components */
import { TransitionOptions } from '@uirouter/core';
import * as React from 'react';
export interface UISrefProps {
    children?: any;
    to: string;
    params?: object;
    options?: TransitionOptions;
    className?: string;
}
/**
 * This component lets create links to router states, allowing the user to navigate through the application.
 * It works well together with `<a>` and `<button>` nodes.
 *
 * You can wrap your anchor/button and define the router state you want it to link to via props.
 * If the state has an associated URL, it will automatically generate and update the `href` attribute.
 * Cliking its children will trigger a state transition with the optional parameters.
 *
 * #### Example:
 * ```jsx
 * // state definition
 * const state = {
 *   name: 'catalog',
 *   url: '/shop/catalog?productId',
 *   component: Catalog
 * }
 *
 * // UISref component
 * <UISref to="catalog" params={{productId:103}}>
 *   <a>Product 103</a>
 * </UISref>
 *
 * // rendered dom
 * <a href="#/shop/catalog?productId=103">Product 103</a>
 * ```
 *
 * It will also respect the default behavior when the user Cmd+Click / Ctrl+Click on the link by canceling the transition event and opening a new tab instead.
 */
export declare const UISref: React.FC<UISrefProps>;
