import * as React from 'react';
import { ComponentType, ReactNode, Component } from 'react';
import { StateParams, Transition, ViewContext } from '@uirouter/core';
/** @internalapi */
export interface UIViewAddress {
    context: ViewContext;
    fqn: string;
}
/**
 * Interface for [[InjectedProps.resolves]]
 *
 * This Typescript interface shows what fields are available on the `resolves` field.
 */
export interface UIViewResolves {
    /**
     * Any key/value pair defined by a state's resolve
     *
     * If a state defines any [[ReactStateDeclaration.resolve]]s, they will be found on this object.
     */
    [key: string]: any;
    /**
     * The `StateParams` for the `Transition` that activated the component
     *
     * This is an alias for:
     * ```js
     * let $stateParams = $transition$.params("to");
     * ```
     */
    $stateParams: StateParams;
    /** The `Transition` that activated the component */
    $transition$: Transition;
}
/**
 * Function type for [[UIViewProps.render]]
 *
 * If the `render` function prop is provided, the `UIView` will use it instead of rendering the component by itself.
 * @internalapi
 */
export declare type RenderPropCallback = (Component: ComponentType<any>, Props: any) => JSX.Element | null;
export interface UIViewInjectedProps {
    transition?: Transition;
    resolves?: UIViewResolves;
    className?: string;
    style?: Object;
}
/** Component Props for `UIView` */
export interface UIViewProps {
    children?: ReactNode;
    name?: string;
    className?: string;
    style?: Object;
    render?: RenderPropCallback;
}
export declare const TransitionPropCollisionError: string;
/** @internalapi */
export declare const UIViewContext: React.Context<UIViewAddress>;
/** @deprecated use [[useParentView]] or React.useContext(UIViewContext) */
export declare const UIViewConsumer: React.Consumer<UIViewAddress>;
export declare class UIView extends Component<UIViewProps> {
    static displayName: string;
    static propTypes: React.WeakValidationMap<UIViewProps & React.RefAttributes<unknown>>;
    static __internalViewComponent: ComponentType<UIViewProps>;
    render(): JSX.Element;
}
