/** @packageDocumentation @reactapi @module react */
import { UIRouter } from '@uirouter/core';
/** @hidden */
export declare const StartMethodCalledMoreThanOnceError = "\n  The Router.start() method has been called more than once.\n\n  The <UIRouter> component calls start() as final step of the initialization and you shouldn't need to call it manually.\n";
/**
 * The main UIRouter object
 *
 * This is the main UIRouter object.
 * There should be one instance of this object per running application.
 *
 * This class has references to all the other UIRouter services.
 */
export declare class UIRouterReact extends UIRouter {
    started: boolean;
    /**
     * Creates a new UIRouter instance
     *
     * This can be used to manually bootstrap the router.
     *
     * #### Example:
     * ```js
     * import { UIRouterReact } from "ui-router-ng2";
     * let routerInstance = new UIRouterReact();
     * routerInstance.start();
     * ```
     */
    constructor();
    /**
     * Starts the router
     *
     * Calling this method enables listening to the URL for changes.
     * It also performs the initial state synchronization from the URL.
     */
    start(): void;
}
