/** @packageDocumentation @reactapi @module react_hooks */
import { useState } from 'react';
import { useOnStateChanged } from './useOnStateChanged';
import { useRouter } from './useRouter';
/**
 * A hook that returns the current state and parameter values.
 *
 * Each time the current state or parameter values change, the component will re-render with the new values.
 *
 * Example:
 * ```jsx
 * function CurrentState() {
 *   const { state, params } = useCurrentStateAndParams();
 *   return <span>{state.name} ({JSON.stringify(params)})</span>;
 * }
 * ```
 */
export function useCurrentStateAndParams() {
    var globals = useRouter().globals;
    var _a = useState({ state: globals.current, params: globals.params }), stateData = _a[0], setStateData = _a[1];
    useOnStateChanged(function (state, params) { return setStateData({ state: state, params: params }); });
    return stateData;
}
//# sourceMappingURL=useCurrentStateAndParams.js.map