/** @packageDocumentation @internalapi @module react_hooks */
import { useContext, useMemo } from 'react';
import { UIViewContext } from '../components';
import { useRouter } from './useRouter';
/** @internalapi Gets the parent UIViewAddress from context, or the root UIViewAddress */
export function useParentView() {
    var router = useRouter();
    var parentUIViewContext = useContext(UIViewContext);
    return useMemo(function () {
        return parentUIViewContext ? parentUIViewContext : { fqn: '', context: router.stateRegistry.root() };
    }, [parentUIViewContext, router]);
}
//# sourceMappingURL=useParentView.js.map