/** @packageDocumentation @reactapi @module react_hooks */
import { UIRouter } from '@uirouter/core';
/** @hidden */
export declare const UIRouterInstanceUndefinedError = "UIRouter instance is undefined. Did you forget to include the <UIRouter> as root component?";
/**
 * A hook that returns the UIRouter instance
 *
 * Example:
 * ```jsx
 * const FormSubmit() {
 *   const router = useRouter();
 *   const form = useContext(FormFromContext);
 *   function submit() {
 *     validateForm(form)
 *       .then(submitForm)
 *       .then(() => router.stateService.go('home'));
 *   }
 *
 *   return <button onClick={submit}>Submit form</button>;
 * }
 * ```
 */
export declare function useRouter(): UIRouter;
