/** @packageDocumentation @reactapi @module react_hooks */
import { useEffect } from 'react';
import { useDeepObjectDiff } from './useDeepObjectDiff';
import { useRouter } from './useRouter';
import { useStableCallback } from './useStableCallback';
export function useTransitionHook(hookRegistrationFnName, criteria, callback, options) {
    var transitionService = useRouter().transitionService;
    var stableCallback = useStableCallback(callback);
    useEffect(function () {
        if (!!criteria) {
            var deregister_1 = transitionService[hookRegistrationFnName](criteria, stableCallback, options);
            return function () { return deregister_1(); };
        }
        else {
            return function () { };
        }
    }, [transitionService, hookRegistrationFnName, useDeepObjectDiff(criteria), useDeepObjectDiff(options)]);
}
//# sourceMappingURL=useTransitionHook.js.map