"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @packageDocumentation @reactapi @module components */
var core_1 = require("@uirouter/core");
var _classNames = require("classnames");
var PropTypes = require("prop-types");
var react_1 = require("react");
var useSref_1 = require("../hooks/useSref");
/** @hidden */
var classNames = _classNames;
/**
 * This component lets create links to router states, allowing the user to navigate through the application.
 * It works well together with `<a>` and `<button>` nodes.
 *
 * You can wrap your anchor/button and define the router state you want it to link to via props.
 * If the state has an associated URL, it will automatically generate and update the `href` attribute.
 * Cliking its children will trigger a state transition with the optional parameters.
 *
 * #### Example:
 * ```jsx
 * // state definition
 * const state = {
 *   name: 'catalog',
 *   url: '/shop/catalog?productId',
 *   component: Catalog
 * }
 *
 * // UISref component
 * <UISref to="catalog" params={{productId:103}}>
 *   <a>Product 103</a>
 * </UISref>
 *
 * // rendered dom
 * <a href="#/shop/catalog?productId=103">Product 103</a>
 * ```
 *
 * It will also respect the default behavior when the user Cmd+Click / Ctrl+Click on the link by canceling the transition event and opening a new tab instead.
 */
exports.UISref = function (_a) {
    var children = _a.children, className = _a.className, options = _a.options, params = _a.params, to = _a.to;
    var _b = useSref_1.useSref(to, params, options), onClick = _b.onClick, href = _b.href;
    var childrenProps = children.props;
    var handleClick = react_1.useCallback(function (e) {
        var childOnClick = childrenProps.onClick;
        if (core_1.isFunction(childOnClick)) {
            childOnClick(e);
        }
        onClick(e);
    }, [childrenProps, onClick]);
    var props = react_1.useMemo(function () {
        return Object.assign({}, childrenProps, {
            onClick: handleClick,
            href: href,
            className: classNames(className, childrenProps.className),
        });
    }, [childrenProps, handleClick, href, className]);
    return react_1.useMemo(function () { return react_1.cloneElement(children, props); }, [children, props]);
};
exports.UISref.displayName = 'UISref';
exports.UISref.propTypes = {
    children: PropTypes.element.isRequired,
    to: PropTypes.string.isRequired,
    params: PropTypes.object,
    options: PropTypes.object,
    className: PropTypes.string,
};
exports.UISref.defaultProps = {
    params: {},
    options: {},
    className: null,
};
//# sourceMappingURL=UISref.js.map