/** @packageDocumentation @reactapi @module components */
import * as React from 'react';
export interface UISrefActiveState {
    stateName: string;
    params: object;
}
/** @hidden */
export declare type AddStateInfoFn = (to: string, params: {
    [key: string]: any;
}) => () => void;
export declare const UISrefActiveContext: React.Context<AddStateInfoFn>;
export interface UISrefActiveProps {
    /**
     * The class string to apply when the state is active (i.e. `"menu-item-active"`)
     */
    class?: string;
    /**
     * Whether the target state of the child [[UISref]] should match exactly the state or could also be a child state.
     * When set to `true`, if state params are supplied then they will be tested for strict equality against the current active url params, so all params must match with none missing and no extras.
     */
    exact?: Boolean;
    /**
     * The component to apply the active class to. It should be a [[UISref]] or any node with [[UISref]] descendant
     */
    children?: any;
    /**
     * Any class will be passed down to its child component
     */
    className?: string;
}
/**
 * A component working alongside `[[UISref]]` to add classes to its child element when one of the included `[[UISref]]`'s state is active, and removing them when it is inactive.
 *
 * The primary use-case is to simplify the special appearance of navigation menus relying on `[[<UISref>]]`, by having the "active" state's menu button appear different, distinguishing it from the inactive menu items.
 *
 * It will register **every** nested `[[<UISref>]]` and add the class to its child every time one of the states is active.
 *
 * ```jsx
 * <UISrefActive class="active-item">
 *   <UISref to="homestate"><a class="menu-item">Home</a></UISref>
 * </UISrefActive>
 *
 * // rendered when state is inactive
 * <a href="/path/to/homestate" class="menu-item">Home</a>
 *
 * // rendered when state is active
 * <a href="/path/to/homestate" class="menu-item active-item">Home</a>
 * ```
 */
export declare function UISrefActive({ children, className, class: classToApply, exact }: UISrefActiveProps): JSX.Element;
