"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
/** @packageDocumentation @reactapi @module components */
var React = require("react");
var react_1 = require("react");
var _classNames = require("classnames");
var hooks_1 = require("../hooks");
/** @hidden */
var classNames = _classNames;
/** @internalapi */
var rootAddStateInfoFn = function () { return function () { return undefined; }; };
exports.UISrefActiveContext = React.createContext(rootAddStateInfoFn);
/**
 * A component working alongside `[[UISref]]` to add classes to its child element when one of the included `[[UISref]]`'s state is active, and removing them when it is inactive.
 *
 * The primary use-case is to simplify the special appearance of navigation menus relying on `[[<UISref>]]`, by having the "active" state's menu button appear different, distinguishing it from the inactive menu items.
 *
 * It will register **every** nested `[[<UISref>]]` and add the class to its child every time one of the states is active.
 *
 * ```jsx
 * <UISrefActive class="active-item">
 *   <UISref to="homestate"><a class="menu-item">Home</a></UISref>
 * </UISrefActive>
 *
 * // rendered when state is inactive
 * <a href="/path/to/homestate" class="menu-item">Home</a>
 *
 * // rendered when state is active
 * <a href="/path/to/homestate" class="menu-item active-item">Home</a>
 * ```
 */
function UISrefActive(_a) {
    var children = _a.children, className = _a.className, classToApply = _a.class, exact = _a.exact;
    var stateService = hooks_1.useRouter().stateService;
    var parentAddStateInfo = react_1.useContext(exports.UISrefActiveContext);
    // keep track of states to watch and their activeClasses
    var _b = react_1.useState([]), uiSrefs = _b[0], setUiSrefs = _b[1];
    var currentState = hooks_1.useCurrentStateAndParams();
    var isAnyUiSrefActive = react_1.useMemo(function () {
        return uiSrefs.some(function (_a) {
            var stateName = _a.stateName, params = _a.params;
            return exact ? stateService.is(stateName, params) : stateService.includes(stateName, params);
        });
    }, [uiSrefs, exact, stateService, currentState]);
    var addStateInfo = react_1.useCallback(function (stateName, params) {
        var parentDeregister = parentAddStateInfo(stateName, params);
        var addedUiSref = { stateName: stateName, params: params };
        setUiSrefs(function (uiSrefs) { return uiSrefs.concat(addedUiSref); });
        return function () {
            parentDeregister();
            setUiSrefs(function (uiSrefs) { return uiSrefs.filter(function (x) { return x !== addedUiSref; }); });
        };
    }, [parentAddStateInfo]);
    // If any active class is defined, apply it the children
    var childrenWithActiveClasses = isAnyUiSrefActive
        ? react_1.cloneElement(children, __assign(__assign({}, children.props), { className: classNames(className, children.props.className, classToApply) }))
        : children;
    return React.createElement(exports.UISrefActiveContext.Provider, { value: addStateInfo }, childrenWithActiveClasses);
}
exports.UISrefActive = UISrefActive;
//# sourceMappingURL=UISrefActive.js.map