"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
/** @packageDocumentation @reactapi @module components */
var PropTypes = require("prop-types");
var React = require("react");
var react_1 = require("react");
var core_1 = require("@uirouter/core");
var useParentView_1 = require("../hooks/useParentView");
var useRouter_1 = require("../hooks/useRouter");
/** @internalapi */
var viewIdCounter = 0;
exports.TransitionPropCollisionError = '`transition` cannot be used as resolve token. ' +
    'Please rename your resolve to avoid conflicts with the router transition.';
/** @internalapi */
exports.UIViewContext = react_1.createContext(undefined);
/** @deprecated use [[useParentView]] or React.useContext(UIViewContext) */
exports.UIViewConsumer = exports.UIViewContext.Consumer;
/** @hidden */
function useResolvesWithStringTokens(resolveContext, injector) {
    return react_1.useMemo(function () {
        if (resolveContext && injector) {
            var stringTokens = resolveContext.getTokens().filter(function (x) { return typeof x === 'string'; });
            if (stringTokens.indexOf('transition') !== -1) {
                throw new Error(exports.TransitionPropCollisionError);
            }
            return stringTokens.map(function (token) { return [token, injector.get(token)]; }).reduce(core_1.applyPairs, {});
        }
        else {
            return {};
        }
    }, [resolveContext, injector]);
}
/* @hidden These are the props are passed to the routed component. */
function useRoutedComponentProps(router, stateName, viewConfig, component, resolves, className, style, transition) {
    var keyCounterRef = react_1.useRef(0);
    // Always re-mount if the viewConfig changes
    var key = react_1.useMemo(function () { return (++keyCounterRef.current).toString(); }, [viewConfig]);
    var baseChildProps = react_1.useMemo(function () { return (__assign(__assign({}, resolves), { 
        // if a className prop was passed to the UIView, forward it
        className: className,
        // if a style prop was passed to the UIView, forward it
        style: style,
        // the transition
        transition: transition,
        // this key updates whenever the state is reloaded, causing the component to remount
        key: key })); }, [component, resolves, className, style, transition, key]);
    var maybeRefProp = useUiCanExitClassComponentHook(router, stateName, component);
    return react_1.useMemo(function () { return (__assign(__assign({}, baseChildProps), maybeRefProp)); }, [baseChildProps, maybeRefProp]);
}
/** @hidden */
function useViewConfig() {
    var _a = react_1.useState(), viewConfig = _a[0], setViewConfig = _a[1];
    var viewConfigRef = react_1.useRef(viewConfig);
    viewConfigRef.current = viewConfig;
    var configUpdated = function (newConfig) {
        if (newConfig !== viewConfigRef.current) {
            setViewConfig(newConfig);
        }
    };
    return { viewConfig: viewConfig, configUpdated: configUpdated };
}
/** @hidden */
function useReactHybridApi(ref, uiViewData, uiViewAddress) {
    var reactHybridApi = react_1.useRef({ uiViewData: uiViewData, uiViewAddress: uiViewAddress });
    reactHybridApi.current.uiViewData = uiViewData;
    reactHybridApi.current.uiViewAddress = uiViewAddress;
    react_1.useImperativeHandle(ref, function () { return reactHybridApi.current; });
}
/**
 * If a class component is being rendered, wire up its uiCanExit method
 * Return a { ref: Ref<ClassComponentInstance> } if passed a component class
 * Return an empty object {} if passed anything else
 * The returned object should be spread as props onto the child component
 * @hidden
 */
function useUiCanExitClassComponentHook(router, stateName, maybeComponentClass) {
    // Use refs and run the callback outside of any render pass
    var componentInstanceRef = react_1.useRef();
    var deregisterRef = react_1.useRef(function () { return undefined; });
    function callbackRef(componentInstance) {
        // Use refs
        var previous = componentInstanceRef.current;
        var deregisterPreviousTransitionHook = deregisterRef.current;
        if (previous !== componentInstance) {
            componentInstanceRef.current = componentInstance;
            deregisterPreviousTransitionHook();
            var uiCanExit = componentInstance === null || componentInstance === void 0 ? void 0 : componentInstance.uiCanExit;
            if (uiCanExit) {
                var boundCallback = uiCanExit.bind(componentInstance);
                deregisterRef.current = router.transitionService.onBefore({ exiting: stateName }, boundCallback);
            }
            else {
                deregisterRef.current = function () { return undefined; };
            }
        }
    }
    return react_1.useMemo(function () {
        var _a;
        var isComponentClass = ((_a = maybeComponentClass === null || maybeComponentClass === void 0 ? void 0 : maybeComponentClass.prototype) === null || _a === void 0 ? void 0 : _a.render) || (maybeComponentClass === null || maybeComponentClass === void 0 ? void 0 : maybeComponentClass.render);
        return isComponentClass ? { ref: callbackRef } : undefined;
    }, [maybeComponentClass]);
}
var View = react_1.forwardRef(function View(props, forwardedRef) {
    var _a;
    var children = props.children, render = props.render, className = props.className, style = props.style;
    var router = useRouter_1.useRouter();
    var parent = useParentView_1.useParentView();
    var creationContext = parent.context;
    var _b = useViewConfig(), viewConfig = _b.viewConfig, configUpdated = _b.configUpdated;
    var component = react_1.useMemo(function () { var _a; return (_a = viewConfig === null || viewConfig === void 0 ? void 0 : viewConfig.viewDecl) === null || _a === void 0 ? void 0 : _a.component; }, [viewConfig]);
    var name = props.name || '$default';
    var fqn = parent.fqn ? parent.fqn + '.' + name : name;
    var id = react_1.useMemo(function () { return ++viewIdCounter; }, []);
    // This object contains all the metadata for this UIView
    var uiViewData = react_1.useMemo(function () {
        return { $type: 'react', id: id, name: name, fqn: fqn, creationContext: creationContext, configUpdated: configUpdated, config: viewConfig };
    }, [id, name, fqn, parent, creationContext, viewConfig]);
    var viewContext = (_a = viewConfig === null || viewConfig === void 0 ? void 0 : viewConfig.viewDecl) === null || _a === void 0 ? void 0 : _a.$context;
    var stateName = viewContext === null || viewContext === void 0 ? void 0 : viewContext.name;
    var uiViewAddress = { fqn: fqn, context: viewContext };
    var resolveContext = react_1.useMemo(function () { return (viewConfig ? new core_1.ResolveContext(viewConfig.path) : undefined); }, [viewConfig]);
    var injector = react_1.useMemo(function () { return resolveContext === null || resolveContext === void 0 ? void 0 : resolveContext.injector(); }, [resolveContext]);
    var transition = react_1.useMemo(function () { return injector === null || injector === void 0 ? void 0 : injector.get(core_1.Transition); }, [injector]);
    var resolves = useResolvesWithStringTokens(resolveContext, injector);
    var childProps = useRoutedComponentProps(router, stateName, viewConfig, component, resolves, className, style, transition);
    // temporarily expose a ref with an API on it for @uirouter/react-hybrid to use
    useReactHybridApi(forwardedRef, uiViewData, uiViewAddress);
    // Register/deregister any time the uiViewData changes
    react_1.useEffect(function () { return router.viewService.registerUIView(uiViewData); }, [uiViewData]);
    var childElement = !component && react_1.isValidElement(children)
        ? react_1.cloneElement(children, childProps)
        : react_1.createElement(component || 'div', childProps);
    // if a render function is passed, use that. otherwise render the component normally
    var ChildOrRenderFunction = typeof render !== 'undefined' && component ? render(component, childProps) : childElement;
    return React.createElement(exports.UIViewContext.Provider, { value: uiViewAddress }, ChildOrRenderFunction);
});
View.displayName = 'UIView';
View.propTypes = {
    name: PropTypes.string,
    className: PropTypes.string,
    style: PropTypes.object,
    render: PropTypes.func,
};
// A wrapper class for react-hybrid to monkey patch
var UIView = /** @class */ (function (_super) {
    __extends(UIView, _super);
    function UIView() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UIView.prototype.render = function () {
        return React.createElement(View, __assign({}, this.props));
    };
    UIView.displayName = 'UIView';
    UIView.propTypes = View.propTypes;
    UIView.__internalViewComponent = View;
    return UIView;
}(react_1.Component));
exports.UIView = UIView;
//# sourceMappingURL=UIView.js.map