"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/** @packageDocumentation @reactapi @module react */
var core_1 = require("@uirouter/core");
var reactViews_1 = require("./reactViews");
/**
 * React View Config Factory
 *
 * Given a path and a [[ReactViewDeclaration]]
 * (the view declaration object found on the state declaration),
 * returns a [[ReactViewConfig]]
 *
 * The ReactViewConfig is an instance of a view,
 * which will be provided to the matching `UIView` Component's
 * [[UIView.viewConfigUpdated]] function.
 *
 * @internalapi
 */
var viewConfigFactory = function (node, config) { return new reactViews_1.ReactViewConfig(node, config); };
/** @hidden */
exports.StartMethodCalledMoreThanOnceError = "\n  The Router.start() method has been called more than once.\n\n  The <UIRouter> component calls start() as final step of the initialization and you shouldn't need to call it manually.\n";
/**
 * The main UIRouter object
 *
 * This is the main UIRouter object.
 * There should be one instance of this object per running application.
 *
 * This class has references to all the other UIRouter services.
 */
var UIRouterReact = /** @class */ (function (_super) {
    __extends(UIRouterReact, _super);
    /**
     * Creates a new UIRouter instance
     *
     * This can be used to manually bootstrap the router.
     *
     * #### Example:
     * ```js
     * import { UIRouterReact } from "ui-router-ng2";
     * let routerInstance = new UIRouterReact();
     * routerInstance.start();
     * ```
     */
    function UIRouterReact() {
        var _this = _super.call(this) || this;
        _this.started = false;
        _this.viewService._pluginapi._viewConfigFactory('react', viewConfigFactory);
        _this.stateRegistry.decorator('views', reactViews_1.reactViewsBuilder);
        return _this;
    }
    /**
     * Starts the router
     *
     * Calling this method enables listening to the URL for changes.
     * It also performs the initial state synchronization from the URL.
     */
    UIRouterReact.prototype.start = function () {
        // Throw error if user calls `start` more than once
        if (this.started) {
            throw new Error(exports.StartMethodCalledMoreThanOnceError);
        }
        else {
            this.urlMatcherFactory.$get();
            this.urlRouter.listen();
            this.urlRouter.sync();
            this.started = true;
        }
    };
    return UIRouterReact;
}(core_1.UIRouter));
exports.UIRouterReact = UIRouterReact;
//# sourceMappingURL=core.js.map