import { RawParams, StateDeclaration } from '@uirouter/core';
/**
 * A hook that returns the current state and parameter values.
 *
 * Each time the current state or parameter values change, the component will re-render with the new values.
 *
 * Example:
 * ```jsx
 * function CurrentState() {
 *   const { state, params } = useCurrentStateAndParams();
 *   return <span>{state.name} ({JSON.stringify(params)})</span>;
 * }
 * ```
 */
export declare function useCurrentStateAndParams(): {
    state: StateDeclaration;
    params: RawParams;
};
