"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @packageDocumentation @reactapi @module react_hooks */
var react_1 = require("react");
var useOnStateChanged_1 = require("./useOnStateChanged");
var useRouter_1 = require("./useRouter");
/**
 * A hook that returns the current state and parameter values.
 *
 * Each time the current state or parameter values change, the component will re-render with the new values.
 *
 * Example:
 * ```jsx
 * function CurrentState() {
 *   const { state, params } = useCurrentStateAndParams();
 *   return <span>{state.name} ({JSON.stringify(params)})</span>;
 * }
 * ```
 */
function useCurrentStateAndParams() {
    var globals = useRouter_1.useRouter().globals;
    var _a = react_1.useState({ state: globals.current, params: globals.params }), stateData = _a[0], setStateData = _a[1];
    useOnStateChanged_1.useOnStateChanged(function (state, params) { return setStateData({ state: state, params: params }); });
    return stateData;
}
exports.useCurrentStateAndParams = useCurrentStateAndParams;
//# sourceMappingURL=useCurrentStateAndParams.js.map