"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @packageDocumentation @internalapi @module react_hooks */
var core_1 = require("@uirouter/core");
var react_1 = require("react");
/** Internal hook to support deep diffing in hook dependencies */
function useDeepObjectDiff(obj) {
    var ref = react_1.useRef(obj);
    var version = react_1.useRef(1);
    var deepEqual = obj === ref.current || core_1.equals(obj, ref.current);
    ref.current = obj;
    if (!deepEqual) {
        version.current++;
    }
    return version.current;
}
exports.useDeepObjectDiff = useDeepObjectDiff;
//# sourceMappingURL=useDeepObjectDiff.js.map