/** @packageDocumentation @reactapi @module react_hooks */
/**
 * A hook that returns true if a given state is active.
 *
 * Example:
 * ```jsx
 * function ContactsLabel() {
 *  const isActive = useIsActive('contacts');
 *  return <span className={isActive ? 'active' : 'inactive'}>Contacts></span>
 * }
 * ```
 *
 * Example:
 * ```jsx
 * function JoeLabel() {
 *  const isActive = useIsActive('contacts.contact', { contactId: 'joe' });
 *  return <span className={isActive ? 'active' : 'inactive'}>Joe></span>
 * }
 * ```
 *
 * @param stateName the name of the state to check.
 *        Relative state names such as '.child' are supported.
 *        Relative states are resolved relative to the state that rendered the hook.
 * @param params if present, the hook will only return true if all the provided parameter values match.
 * @param exact when true, the hook returns true only when the state matches exactly.
 *        when false, returns true if the state matches, or any child state matches.
 */
export declare function useIsActive(stateName: string, params?: any, exact?: boolean): boolean;
