"use strict";
/** @packageDocumentation @reactapi @module react_hooks */
Object.defineProperty(exports, "__esModule", { value: true });
var useTransitionHook_1 = require("./useTransitionHook");
/**
 * A hook that invokes the provided callback whenever the current state changes.
 *
 * The callback receives the [[StateDeclaration]] and parameter values of the new current state.
 *
 * Example:
 * ```jsx
 * function ShowCurrentState() {
 *   const [routerState, setRouterState] = useState('');
 *   useOnStateChanged((state) => setState(state.name);
 *   return <span>{routerState ? `state changed to ${routerState}` : null}</span>
 * }
 * ```
 *
 * @param onStateChangedCallback a callback that receives the new current state and parameter values
 */
function useOnStateChanged(onStateChangedCallback) {
    useTransitionHook_1.useTransitionHook('onSuccess', {}, function (trans) { return onStateChangedCallback(trans.to(), trans.params('to')); });
}
exports.useOnStateChanged = useOnStateChanged;
//# sourceMappingURL=useOnStateChanged.js.map