"use strict";
/** @packageDocumentation @internalapi @module react_hooks */
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var components_1 = require("../components");
var useRouter_1 = require("./useRouter");
/** @internalapi Gets the parent UIViewAddress from context, or the root UIViewAddress */
function useParentView() {
    var router = useRouter_1.useRouter();
    var parentUIViewContext = react_1.useContext(components_1.UIViewContext);
    return react_1.useMemo(function () {
        return parentUIViewContext ? parentUIViewContext : { fqn: '', context: router.stateRegistry.root() };
    }, [parentUIViewContext, router]);
}
exports.useParentView = useParentView;
//# sourceMappingURL=useParentView.js.map