"use strict";
/** @packageDocumentation @reactapi @module react_hooks */
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var UIRouter_1 = require("../components/UIRouter");
/** @hidden */
exports.UIRouterInstanceUndefinedError = "UIRouter instance is undefined. Did you forget to include the <UIRouter> as root component?";
/**
 * A hook that returns the UIRouter instance
 *
 * Example:
 * ```jsx
 * const FormSubmit() {
 *   const router = useRouter();
 *   const form = useContext(FormFromContext);
 *   function submit() {
 *     validateForm(form)
 *       .then(submitForm)
 *       .then(() => router.stateService.go('home'));
 *   }
 *
 *   return <button onClick={submit}>Submit form</button>;
 * }
 * ```
 */
function useRouter() {
    var router = react_1.useContext(UIRouter_1.UIRouterContext);
    if (!router) {
        throw new Error(exports.UIRouterInstanceUndefinedError);
    }
    return router;
}
exports.useRouter = useRouter;
//# sourceMappingURL=useRouter.js.map