/** @packageDocumentation @reactapi @module react_hooks */
import * as React from 'react';
import { TransitionOptions } from '@uirouter/core';
export interface LinkProps {
    onClick: React.MouseEventHandler<any>;
    href?: string;
}
/** @hidden */
export declare const IncorrectStateNameTypeError = "The state name passed to useSref must be a string.";
/**
 * A hook to create a link to a state.
 *
 * This hook returns link (anchor tag) props for a given state reference.
 * The resulting props can be spread onto an anchor tag.
 *
 * The props returned from this hook are:
 *
 * - `href`: the browser URL of the referenced state
 * - `onClick`: a mouse event handler that will active the referenced state
 *
 * Example:
 * ```jsx
 * function HomeLink() {
 *   const sref = useSref('home');
 *   return <a {...sref}>Home</a>
 * }
 * ```
 *
 * Example:
 * ```jsx
 * function UserLink({ userId, username }) {
 *   const sref = useSref('users.user', { userId: userId });
 *   return <a {...sref}>{username}</a>
 * }
 * ```
 *
 * @param stateName The name of the state to link to
 * @param params Any parameter values
 * @param options Transition options used when the onClick handler fires.
 */
export declare function useSref(stateName: string, params?: object, options?: TransitionOptions): LinkProps;
