"use strict";
/** @packageDocumentation @reactapi @module react_hooks */
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useDeepObjectDiff_1 = require("./useDeepObjectDiff");
var useRouter_1 = require("./useRouter");
var useStableCallback_1 = require("./useStableCallback");
function useTransitionHook(hookRegistrationFnName, criteria, callback, options) {
    var transitionService = useRouter_1.useRouter().transitionService;
    var stableCallback = useStableCallback_1.useStableCallback(callback);
    react_1.useEffect(function () {
        if (!!criteria) {
            var deregister_1 = transitionService[hookRegistrationFnName](criteria, stableCallback, options);
            return function () { return deregister_1(); };
        }
        else {
            return function () { };
        }
    }, [transitionService, hookRegistrationFnName, useDeepObjectDiff_1.useDeepObjectDiff(criteria), useDeepObjectDiff_1.useDeepObjectDiff(options)]);
}
exports.useTransitionHook = useTransitionHook;
//# sourceMappingURL=useTransitionHook.js.map