/** @module rx */
/** */
import "rxjs/add/operator/mergeMap";
import "rxjs/add/operator/map";
import { ReplaySubject } from "rxjs/ReplaySubject";
/** Augments UIRouterGlobals with observables for transition starts, successful transitions, and state parameters */
var UIRouterRx = (function () {
    function UIRouterRx(router) {
        this.name = 'ui-router-rx';
        this.deregisterFns = [];
        var start$ = new ReplaySubject(1);
        var success$ = start$.mergeMap(function (t) { return t.promise.then(function () { return t; }); });
        var params$ = success$.map(function (transition) { return transition.params(); });
        var states$ = new ReplaySubject(1);
        function onStatesChangedEvent(event, states) {
            var changeEvent = {
                currentStates: router.stateRegistry.get(),
                registered: [],
                deregistered: []
            };
            if (event)
                changeEvent[event] = states;
            states$.next(changeEvent);
        }
        this.deregisterFns.push(router.transitionService.onStart({}, function (transition) { return start$.next(transition); }));
        this.deregisterFns.push(router.stateRegistry.onStatesChanged(onStatesChangedEvent));
        onStatesChangedEvent(null, null);
        Object.assign(router.globals, { start$: start$, success$: success$, params$: params$, states$: states$ });
    }
    UIRouterRx.prototype.dispose = function () {
        this.deregisterFns.forEach(function (deregisterFn) { return deregisterFn(); });
        this.deregisterFns = [];
    };
    return UIRouterRx;
}());
export { UIRouterRx };
//# sourceMappingURL=ui-router-rx.js.map