/** @module rx */
/** */
import "rxjs/add/operator/mergeMap";
import "rxjs/add/operator/map";
import { Observable } from "rxjs/Observable";
import { Transition, UIRouter, StateDeclaration, UIRouterPlugin } from "@uirouter/core";
export interface StatesChangedEvent {
    currentStates: StateDeclaration[];
    registered: StateDeclaration[];
    deregistered: StateDeclaration[];
}
declare module '@uirouter/core/lib/globals' {
    interface UIRouterGlobals {
        states$?: Observable<StatesChangedEvent>;
        start$?: Observable<Transition>;
        success$?: Observable<Transition>;
        params$?: Observable<{
            [paramName: string]: any;
        }>;
    }
}
/** Augments UIRouterGlobals with observables for transition starts, successful transitions, and state parameters */
export declare class UIRouterRx implements UIRouterPlugin {
    name: string;
    private deregisterFns;
    constructor(router: UIRouter);
    dispose(): void;
}
